/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uibeans.utils;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.jmx.exception.ComponentErrorException;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.to.ComponentTO;
import org.ow2.petals.tools.webconsole.to.DomainTO;
import org.ow2.petals.tools.webconsole.to.EndPointTO;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.to.ServiceAssemblyTO;
import org.ow2.petals.tools.webconsole.utils.PetalsConsoleException;
import org.ow2.petals.tools.webconsole.utils.StringHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class TopologyHelper {
    private static final Log LOGGER = LogFactory.getLog(TopologyHelper.class);

    public static DomainTO getDomain(Set<ServerTO> referentialServers, Set<Map<String, String>> topology, String host, Integer port, String login, String password, String modifiedDomain) throws PetalsServiceTechnicalException, UnknownHostException, PetalsConsoleException {
        if (topology == null || topology.isEmpty()) {
            throw new PetalsConsoleException("Topology cannot be null");
        }
        Iterator<Map<String, String>> entitiesIt = topology.iterator();
        String domainMode = null;
        String subDomainName = null;
        String topologyType = null;
        while (entitiesIt.hasNext()) {
            Map<String, String> entitiesPropertiesMap = entitiesIt.next();
            if (entitiesPropertiesMap.containsKey("type") && entitiesPropertiesMap.get("type").equals("domain")) {
                domainMode = entitiesPropertiesMap.get("domainMode");
                topologyType = entitiesPropertiesMap.get("domain");
                continue;
            }
            if (!entitiesPropertiesMap.containsKey("type") || !entitiesPropertiesMap.get("type").equals("subdomain")) continue;
            subDomainName = entitiesPropertiesMap.get("subdomainName");
        }
        Set allServers = TopologyHelper.getAllServer(topology);
        DomainTO domain = TopologyHelper.getDomain(topology);
        if (domain != null) {
            domain.setMode(domainMode);
            domain.setName(subDomainName);
            domain.setTopologyType(topologyType);
            if (subDomainName == null) {
                subDomainName = modifiedDomain;
            }
            domain.getServers().addAll(TopologyHelper.recoverServer((Set)allServers, (String)subDomainName));
            TopologyHelper.mergeServerInformations((List)domain.getServers(), new ArrayList<ServerTO>(referentialServers));
            TopologyHelper.fillEntitiesForAllServer((Collection)domain.getServers());
            return domain;
        }
        throw new UnknownHostException("Server: " + host + " not found, check the host attribute for declared servers into webconsole.xml");
    }

    private static DomainTO addDomain(Map<String, String> map) {
        DomainTO domain = new DomainTO();
        domain.setDescription(map.get("domainDescription"));
        domain.setName(map.get("domainName"));
        domain.setTopologyType(map.get("domain"));
        return domain;
    }

    private static Set<ServerTO> recoverServer(Set<ServerTO> allServers, String domainName) {
        Iterator<ServerTO> serversIt = allServers.iterator();
        HashSet<ServerTO> goodServers = new HashSet<ServerTO>();
        while (serversIt.hasNext()) {
            ServerTO server = serversIt.next();
            if (!server.getDomainName().equals(domainName)) continue;
            goodServers.add(server);
        }
        return goodServers;
    }

    private static ServerTO addServer(Map<String, String> serverPropertiesMap) {
        ServerTO server = new ServerTO();
        server.setHost(serverPropertiesMap.get("host"));
        server.setLogin(serverPropertiesMap.get("user"));
        server.setPort(serverPropertiesMap.get("jmxRMIPort"));
        server.setPassword(serverPropertiesMap.get("password"));
        server.setDescription(serverPropertiesMap.get("containerDescription"));
        server.setConfTransportTCPPort(serverPropertiesMap.get("transportTCPPort"));
        server.setConfTransportSSLPort(serverPropertiesMap.get("transportSSLPort"));
        server.setConfTransportHTTPPort(serverPropertiesMap.get("transportHTTPPort"));
        server.setName(serverPropertiesMap.get("containerName"));
        server.setState(serverPropertiesMap.get("state"));
        server.setDomainName(serverPropertiesMap.get("subdomainName"));
        return server;
    }

    private static Set<ServerTO> getAllServer(Set<Map<String, String>> topology) {
        HashSet<ServerTO> servers = new HashSet<ServerTO>();
        for (Map<String, String> entitiesPropertiesMap : topology) {
            if (!entitiesPropertiesMap.containsKey("type") || !entitiesPropertiesMap.get("type").equals("container")) continue;
            servers.add(TopologyHelper.addServer(entitiesPropertiesMap));
        }
        return servers;
    }

    private static DomainTO getDomain(Set<Map<String, String>> topology) {
        for (Map<String, String> entitiesPropertiesMap : topology) {
            if (!entitiesPropertiesMap.containsKey("type") || !entitiesPropertiesMap.get("type").equals("domain")) continue;
            return TopologyHelper.addDomain(entitiesPropertiesMap);
        }
        return null;
    }

    private static void recoverComponentsForServer(ServerTO server, ManagementService service) throws PetalsServiceTechnicalException {
        ObjectName[] allComponents;
        for (ObjectName objectName : allComponents = service.componentsInventory()) {
            ComponentTO component = new ComponentTO();
            component.setName(objectName.getKeyProperty("name"));
            try {
                component.setState(service.getComponentState(component.getName()));
            }
            catch (PetalsServiceTechnicalException e) {
                if (!(e.getCause() instanceof ComponentErrorException)) {
                    throw e;
                }
                component.setState("undefined");
            }
            component.setType("bindingcomponent");
            server.getBindingComponents().add(component);
        }
    }

    private static void recoverEnginesForServer(ServerTO server, ManagementService service) throws PetalsServiceTechnicalException {
        ObjectName[] allEngines;
        for (ObjectName objectName : allEngines = service.enginesInventory()) {
            ComponentTO component = new ComponentTO();
            component.setName(objectName.getKeyProperty("name"));
            try {
                component.setState(service.getComponentState(component.getName()));
            }
            catch (PetalsServiceTechnicalException e) {
                if (!(e.getCause() instanceof ComponentErrorException)) {
                    throw e;
                }
                component.setState("undefined");
            }
            component.setType("serviceengine");
            server.getServiceEngines().add(component);
        }
    }

    private static void recoverServiceAssembliesForServer(ServerTO server, ManagementService service) throws PetalsServiceTechnicalException {
        ServiceAssemblyTO serviceAssembly;
        String[] componentSAs;
        for (ComponentTO componentTO : server.getBindingComponents()) {
            for (String sa : componentSAs = service.getComponentServiceAssembly(componentTO.getName())) {
                serviceAssembly = new ServiceAssemblyTO();
                serviceAssembly.setName(sa);
                serviceAssembly.setState(service.getServiceAssemblyState(sa));
                server.getServiceAssemblies().add(serviceAssembly);
            }
        }
        for (ComponentTO componentTO : server.getServiceEngines()) {
            for (String sa : componentSAs = service.getComponentServiceAssembly(componentTO.getName())) {
                serviceAssembly = new ServiceAssemblyTO();
                serviceAssembly.setName(sa);
                serviceAssembly.setState(service.getServiceAssemblyState(sa));
                server.getServiceAssemblies().add(serviceAssembly);
            }
        }
    }

    private static void recoverSharedLibraries(ServerTO server, ManagementService service) throws PetalsServiceTechnicalException {
        for (String sharedLibrary : service.sharedLibrariesInventory()) {
            server.getSharedLibraries().add(sharedLibrary);
        }
    }

    public static List<EndPointTO> recoverEndpointsForComponent(String componentName, ManagementService service, String containerName) throws PetalsServiceTechnicalException {
        List allEndpoints = service.getAllEndpoints();
        ArrayList<EndPointTO> endpointsTO = new ArrayList<EndPointTO>();
        for (Map endpoint : allEndpoints) {
            EndPointTO endpointTO = new EndPointTO();
            endpointTO.setComponent((String)endpoint.get("componentName"));
            endpointTO.setServer((String)endpoint.get("componentName"));
            endpointTO.setName((String)endpoint.get("endpointName"));
            endpointTO.setService(QName.valueOf((String)endpoint.get("serviceName")));
            String interfaceNames = null;
            for (String name : (String[])endpoint.get("interfaceNames")) {
                interfaceNames = StringHelper.isNullOrEmpty(interfaceNames) ? QName.valueOf(name).toString() : interfaceNames + "," + QName.valueOf(name);
            }
            endpointTO.setInterfaceName(QName.valueOf(interfaceNames));
            if (!endpointTO.getComponent().equals(componentName) || !containerName.equals((String)endpoint.get("containerName"))) continue;
            endpointsTO.add(endpointTO);
        }
        return endpointsTO;
    }

    public static void fillEntitiesForServer(ServerTO server, ManagementService service) throws PetalsServiceTechnicalException {
        TopologyHelper.recoverComponentsForServer((ServerTO)server, (ManagementService)service);
        TopologyHelper.recoverEnginesForServer((ServerTO)server, (ManagementService)service);
        TopologyHelper.recoverServiceAssembliesForServer((ServerTO)server, (ManagementService)service);
    }

    public static void fillEntitiesForAllServer(Collection<ServerTO> servers) throws PetalsServiceTechnicalException {
        boolean allServerUnAvailable = true;
        for (ServerTO server : servers) {
            try {
                ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(server.getHost(), Integer.valueOf(server.getPort()), server.getLogin(), server.getPassword());
                server.setAvailable(true);
                allServerUnAvailable = false;
                TopologyHelper.recoverComponentsForServer((ServerTO)server, (ManagementService)service);
                TopologyHelper.recoverEnginesForServer((ServerTO)server, (ManagementService)service);
                TopologyHelper.recoverServiceAssembliesForServer((ServerTO)server, (ManagementService)service);
                TopologyHelper.recoverSharedLibraries((ServerTO)server, (ManagementService)service);
            }
            catch (PetalsServiceTechnicalException e) {
                if (e.getCause().getClass().equals(ConnectionErrorException.class)) {
                    server.setAvailable(false);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Error occurred during the filling for all server entities", (Throwable)e);
                    continue;
                }
                LOGGER.warn((Object)("Error occurred during the filling for all server entities: " + e.getMessage()));
            }
        }
        if (allServerUnAvailable) {
            LOGGER.warn((Object)"All servers unavailable");
            throw new PetalsServiceTechnicalException("All servers unavailable in configuration file (verify configured servers in 'Manage servers')");
        }
    }

    private static void mergeServerInformations(List<ServerTO> topoServers, List<ServerTO> referentialServers) {
        for (ServerTO topoServer : topoServers) {
            if (!referentialServers.contains(topoServer)) continue;
            int index = referentialServers.indexOf(topoServer);
            ServerTO referentialServer = referentialServers.get(index);
            topoServer.setHost(referentialServer.getHost());
            topoServer.setPort(referentialServer.getPort());
            topoServer.setLogin(referentialServer.getLogin());
            topoServer.setPassword(referentialServer.getPassword());
            topoServer.setRemoteContext(referentialServer.getRemoteContext());
            topoServer.setRemotePort(referentialServer.getRemotePort());
            topoServer.setInstalledRemoteComponent(referentialServer.isInstalledRemoteComponent());
        }
    }

    public static String getCurrentServerName(Set<Map<String, String>> topology, String host, String port, String login, String password) {
        for (Map<String, String> entitiesPropertiesMap : topology) {
            if (!entitiesPropertiesMap.containsKey("type") || !entitiesPropertiesMap.get("type").equals("container") || !entitiesPropertiesMap.get("host").equals(host) || !entitiesPropertiesMap.get("user").equals(login) || !entitiesPropertiesMap.get("jmxRMIPort").equals(port) || !entitiesPropertiesMap.get("password").equals(password)) continue;
            entitiesPropertiesMap.get("containerName");
        }
        return null;
    }
}

