/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.uicomponents;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.petals.tools.webconsole.utils.ConfigHelper;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;

public class RestResourcesServlet
extends HttpServlet {
    private static final long serialVersionUID = 9172022826957641556L;
    public static final String ARTIFACT_PATH = "/artifacts";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String params = this.requestExtractor(req);
        File artifactDir = GeneralHelper.getArtifactsRepo();
        File artifactFile = new File(artifactDir, params);
        String[] splittedParams = params.split("/");
        if (artifactFile.exists()) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=" + splittedParams[splittedParams.length - 1]);
            resp.setContentLength((int)artifactFile.length());
            ServletOutputStream out = resp.getOutputStream();
            FileInputStream in = new FileInputStream(artifactFile);
            try {
                int nbLecture;
                String cacheControl = (String)ConfigHelper.getConfigurationProperty((String)"cache.control");
                resp.setHeader("Cache-Control", cacheControl);
                resp.setHeader("Pragma", cacheControl);
                byte[] buffer = new byte[524288];
                while ((nbLecture = in.read(buffer)) != -1) {
                    out.write(buffer, 0, nbLecture);
                }
            }
            finally {
                in.close();
                out.close();
            }
        } else {
            resp.sendError(404, "Resource not found [" + splittedParams[splittedParams.length - 1] + "]");
        }
    }

    private String requestExtractor(HttpServletRequest req) {
        String requestedURL = req.getRequestURL().toString();
        int artifactIndex = requestedURL.indexOf(ARTIFACT_PATH);
        String params = requestedURL.substring(artifactIndex + ARTIFACT_PATH.length(), requestedURL.length());
        return params;
    }
}

