/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CSVFileHelper {
    private List<String[]> data = new ArrayList();
    private static final String SEPARATOR = ";";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVFileHelper(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String line = null;
        try {
            while ((line = bufferedReader.readLine()) != null) {
                String[] splittedParts = line.split(SEPARATOR);
                String[] splittedTransformedParts = new String[splittedParts.length];
                for (int i = 0; i < splittedParts.length; ++i) {
                    String value = splittedParts[i];
                    if (value.startsWith("\"")) {
                        value = value.substring(1);
                    }
                    if (value.substring(value.length() - 1).equals("\"")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    splittedTransformedParts[i] = value;
                }
                this.data.add(splittedTransformedParts);
            }
        }
        finally {
            bufferedReader.close();
            fileReader.close();
        }
    }

    public int rowsCount() {
        return this.data.size();
    }

    public int columnsCount(int row) {
        if (row < this.data.size()) {
            return ((String[])this.data.get(row)).length;
        }
        throw new IllegalArgumentException(String.valueOf(this.data.size()) + " rows is contained into CSV file, think the first line begin with index '0'");
    }

    public List<String[]> getData() {
        return this.data;
    }

    public String[] getRowData(int row) {
        if (row < this.data.size()) {
            return (String[])this.data.get(row);
        }
        throw new IllegalArgumentException(String.valueOf(this.data.size()) + " rows is contained into CSV file, think the first line begin with index '0'");
    }
}

