/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.opensuit.xmlmap.XmlInstantiator;
import org.ow2.opensuit.xmlmap.XmlSerializer;
import org.ow2.opensuit.xmlmap.schema.SchemasManager;
import org.ow2.petals.tools.webconsole.to.ServerTO;
import org.ow2.petals.tools.webconsole.utils.GeneralHelper;
import org.ow2.petals.tools.webconsole.xmlbeans.Server;
import org.ow2.petals.tools.webconsole.xmlbeans.Servers;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConfigHelper {
    private static final String PROPERTY_NOT_FOUND_ERROR = " property not found into general.properties file";
    private static final String INPUT_UNAVAILABLE_ERROR = "Input stream for general.properties unavailable";
    private static final Properties PROPERTIES = new Properties();
    private static final Log LOGGER = LogFactory.getLog(ConfigHelper.class);

    public static Set<ServerTO> readConfig(URL webconsoleFile) throws MalformedURLException, IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        XmlInstantiator xi = XmlInstantiator.instantiate((URL)webconsoleFile, null);
        Servers servers = (Servers)xi.getRoot();
        HashSet<ServerTO> serversTO = new HashSet<ServerTO>();
        if (servers.getServers() != null) {
            for (Server server : servers.getServers()) {
                ServerTO serverTO = new ServerTO();
                serverTO.setHost(server.getHost());
                serverTO.setPort(server.getPort());
                serverTO.setLogin(server.getLogin());
                serverTO.setPassword(server.getPassword());
                serverTO.setDomainName(server.getDomain());
                serverTO.setName(server.getName());
                serversTO.add(serverTO);
            }
        }
        return serversTO;
    }

    public static ServerTO findRemoteServer(URL webconsoleFile) throws MalformedURLException, IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        XmlInstantiator xi = XmlInstantiator.instantiate((URL)webconsoleFile, null);
        Servers servers = (Servers)xi.getRoot();
        if (servers.getServers() != null) {
            for (Server server : servers.getServers()) {
                if (!server.isInstalledRemoteComponent()) continue;
                ServerTO serverTO = new ServerTO();
                serverTO.setHost(server.getHost());
                serverTO.setPort(server.getPort());
                serverTO.setRemotePort(server.getRemotePort());
                serverTO.setRemoteContext(server.getRemoteContext());
                serverTO.setLogin(server.getLogin());
                serverTO.setPassword(server.getPassword());
                serverTO.setInstalledRemoteComponent(true);
                serverTO.setDomainName(server.getDomain());
                serverTO.setName(server.getName());
                return serverTO;
            }
        }
        return null;
    }

    public static List<Server> readConfiguration(URL webconsoleFile) throws MalformedURLException, IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
        XmlInstantiator xi = XmlInstantiator.instantiate((URL)webconsoleFile, null);
        Servers servers = (Servers)xi.getRoot();
        ArrayList<Server> serverList = new ArrayList<Server>();
        if (servers.getServers() != null) {
            for (Server server : servers.getServers()) {
                serverList.add(server);
            }
        }
        return serverList;
    }

    public static void writeConfiguration(String instanceFileName, String schemafileName, List<Server> serverList) throws ParserConfigurationException, IOException, URISyntaxException {
        File webconsoleFile = new File(Thread.currentThread().getContextClassLoader().getResource(instanceFileName).toURI().getPath());
        File schema = new File(Thread.currentThread().getContextClassLoader().getResource(schemafileName).toURI().getPath());
        Servers servers = new Servers();
        servers.setServers(serverList.toArray(new Server[serverList.size()]));
        SchemasManager schemasManager = new SchemasManager();
        schemasManager.declareSchema("servers", schema.getPath(), "org.ow2.petals.tools.webconsole.xmlbeans");
        XmlSerializer xs = XmlSerializer.serialize((SchemasManager)schemasManager, (Object)servers);
        try {
            GeneralHelper.writeXmlFile((Document)xs.getDocument(), (File)webconsoleFile);
        }
        catch (TransformerException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn((Object)"Error occurred during writing configuration", (Throwable)e);
            }
            LOGGER.warn((Object)("Error occurred during writing configuration: " + e.getMessage()));
        }
    }

    public static Object getConfigurationProperty(String key) throws IOException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("general.properties");
        if (in != null) {
            PROPERTIES.load(in);
            return PROPERTIES.get(key);
        }
        return null;
    }
}

