/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.tools.webconsole.services.PetalsServiceTechnicalException;
import org.ow2.petals.tools.webconsole.services.management.ManagementService;
import org.ow2.petals.tools.webconsole.services.management.ManagementServiceFactory;
import org.ow2.petals.tools.webconsole.services.utils.FilePermissionHelper;
import org.ow2.petals.tools.webconsole.utils.CSVFileHelper;
import org.ow2.petals.tools.webconsole.utils.StringHelper;
import org.ow2.petals.tools.webconsole.utils.ZipHelper;
import org.w3c.dom.Document;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeneralHelper {
    private static final Log LOGGER;
    public static final String ENDPOINTNAMEPROVIDER = "ENDPOINTNAMEPROVIDER";
    public static final String INTERFACENAMEPROVIDER = "INTERFACENAMEPROVIDER";
    public static final String INTERFACENAMENSURLPROVIDER = "INTERFACENAMENSURLPROVIDER";
    public static final String ADDRESS = "ADDRESS";
    public static final String WSDLVERSION = "WSDLVERSION";
    public static final String NAMESPACEPROVIDER = "NAMESPACEPROVIDER";
    public static final String OPENSUIT_SECURITY_STRING = "res";
    public static final String DISTRIBUTED_INSTALLATION_PROPERTY = "distributed.installation";

    public static void writeXmlFile(Document doc, File file) throws TransformerException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.transform(source, result);
    }

    public static String findHostAddr(String host) throws UnknownHostException {
        String[] subString = host.split("/");
        InetAddress inetAddr = null;
        String addrport = subString[2];
        Pattern pattern = Pattern.compile(":");
        Matcher matcher = pattern.matcher(addrport);
        if (matcher.find()) {
            String hostname = (String)addrport.subSequence(0, addrport.indexOf(":"));
            pattern = Pattern.compile("([0-9]|[0-9]|[0-9]).([0-9]|[0-9]|[0-9]).([0-9]|[0-9]|[0-9]).([0-9]|[0-9]|[0-9])");
            matcher = pattern.matcher(hostname);
            if (!matcher.find()) {
                inetAddr = InetAddress.getByName(hostname);
            }
        }
        if (inetAddr != null) {
            return inetAddr.getHostAddress();
        }
        return null;
    }

    public static String replaceLocalHostByIP() throws IOException {
        InetAddress in = InetAddress.getLocalHost();
        String iPaddress = "";
        InetAddress[] all = InetAddress.getAllByName(in.getHostName());
        for (int i = 0; i < all.length && StringHelper.isNullOrEmpty((String)iPaddress); ++i) {
            InetAddress ia = all[i];
            if (!ia.isReachable(5000)) continue;
            iPaddress = ia.getHostAddress();
        }
        return iPaddress;
    }

    public static String replaceHostByIP(String host) throws UnknownHostException {
        return InetAddress.getByName(host).getHostAddress();
    }

    public static Map<String, String> readDescription(Description description, String endpointName, String serviceName) {
        HashMap<String, String> map = new HashMap<String, String>();
        List servicesList = description.getServices();
        Iterator serviceIt = servicesList.iterator();
        map.put("NAMESPACEPROVIDER", description.getTargetNamespace());
        while (serviceIt.hasNext()) {
            Service s = (Service)serviceIt.next();
            List endpointsList = s.getEndpoints();
            for (Endpoint e : endpointsList) {
                if (!s.getQName().toString().equals(serviceName) || !e.getName().toString().equals(endpointName)) continue;
                map.put("ENDPOINTNAMEPROVIDER", endpointName);
                map.put("INTERFACENAMEPROVIDER", ((InterfaceType)((Binding)e.getBinding()).getInterface()).getQName().getLocalPart().toString());
                map.put("INTERFACENAMENSURLPROVIDER", ((InterfaceType)((Binding)e.getBinding()).getInterface()).getQName().getNamespaceURI());
                map.put("ADDRESS", e.getAddress());
                if (description.getVersion().equals((Object)AbsItfDescription.WSDLVersionConstants.WSDL11)) {
                    map.put("WSDLVERSION", "1.1");
                    continue;
                }
                if (!description.getVersion().equals((Object)AbsItfDescription.WSDLVersionConstants.WSDL20)) continue;
                map.put("WSDLVERSION", "2.0");
            }
        }
        return map;
    }

    public static Description readWSDL(File wsdlFile) throws WSDLException, URISyntaxException, IOException {
        WSDL4ComplexWsdlReader wsdl4ComplexWsdlReader = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader();
        return wsdl4ComplexWsdlReader.read(wsdlFile.toURI().toURL());
    }

    public static Description readWSDL(Document wsdlDocument) throws WSDLException, URISyntaxException, MalformedURLException {
        WSDL4ComplexWsdlReader wsdl4ComplexWsdlReader = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader();
        return wsdl4ComplexWsdlReader.read(wsdlDocument);
    }

    public Document getDocWSDLForEndpoint(String hostname, Integer port, String login, String password, String serviceName, String endpointName) throws PetalsServiceTechnicalException, ConnectionErrorException {
        ManagementService service = (ManagementService)ManagementServiceFactory.getInstance().getService(hostname, port, login, password);
        return service.getDocument(serviceName, endpointName);
    }

    public String getStrWSDLForEndpoint(String hostname, Integer port, String login, String password, String serviceName, String endpointName) throws PetalsServiceTechnicalException, ConnectionErrorException {
        Document doc = this.getDocWSDLForEndpoint(hostname, port, login, password, serviceName, endpointName);
        if (doc != null) {
            return StringHelper.htmlEncoder((String)StringHelper.prettyPrint((Document)this.getDocWSDLForEndpoint(hostname, port, login, password, serviceName, endpointName)));
        }
        return "";
    }

    public static URI getURI(HttpServletRequest httpServletRequest) throws URISyntaxException {
        URI uri = null;
        if (uri == null) {
            uri = GeneralHelper.getURIFromHttpRequest((HttpServletRequest)httpServletRequest);
        }
        if (uri == null) {
            uri = GeneralHelper.getURIFromInetAddress((HttpServletRequest)httpServletRequest);
        }
        if (uri == null) {
            uri = new URI(httpServletRequest.getRequestURI());
        }
        return uri;
    }

    public static URI getURIFromHttpRequest(HttpServletRequest httpServletRequest) throws URISyntaxException {
        URI uri = new URI(httpServletRequest.getRequestURL().toString());
        uri = "localhost".equalsIgnoreCase(uri.getHost()) ? null : new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
        return uri;
    }

    public static URL artifactFinder(HttpServletRequest request, File repo, File repoAttachement, String fileName) throws URISyntaxException, MalformedURLException {
        URI artifactServerUri = GeneralHelper.getURI((HttpServletRequest)request);
        int lastSeparator = artifactServerUri.toString().lastIndexOf("/") + 1;
        String s = artifactServerUri.toString().substring(0, lastSeparator);
        String servletName = request.getServletPath();
        while (!(s = s.substring(0, lastSeparator = s.lastIndexOf("/"))).endsWith(servletName)) {
        }
        URL httpUrl = new URL(s.substring(0, lastSeparator) + "/" + "res" + "/" + repo.getName() + "/" + repoAttachement.getName() + "/" + fileName);
        s = null;
        return httpUrl;
    }

    public static URI getURIFromInetAddress(HttpServletRequest httpServletRequest) throws URISyntaxException {
        URI uri = null;
        try {
            String ip = InetAddress.getLocalHost().getHostAddress();
            uri = new URI(httpServletRequest.getRequestURL().toString());
            uri = new URI(uri.getScheme(), uri.getUserInfo(), ip, uri.getPort(), uri.getPath(), null, null);
        }
        catch (UnknownHostException e) {
            throw new URISyntaxException("InetAddress.getLocalhost()", "URI can not be construct from machine IP information");
        }
        return uri;
    }

    public static File fileFounder(String fileName, File directory) {
        for (File f : directory.listFiles()) {
            if (f.isDirectory()) {
                File file = GeneralHelper.fileFounder((String)fileName, (File)f);
                if (file == null) continue;
                return file;
            }
            if (!f.getName().equals(fileName)) continue;
            return f;
        }
        return null;
    }

    public static void deleteFileTree(File tree) {
        for (File subFile : tree.listFiles()) {
            if (subFile.isDirectory()) {
                GeneralHelper.deleteFileTree((File)subFile);
                continue;
            }
            if (subFile.delete()) continue;
            LOGGER.warn((Object)("Unable to delete file: " + subFile.getPath()));
        }
        if (!tree.delete()) {
            LOGGER.warn((Object)("Unable to delete file: " + tree.getPath()));
        }
    }

    public static void deleteDirectoryContent(File tree) {
        for (File subFile : tree.listFiles()) {
            if (subFile.isDirectory()) {
                GeneralHelper.deleteFileTree((File)subFile);
                continue;
            }
            if (subFile.delete()) continue;
            LOGGER.warn((Object)("Unable to delete file: " + subFile.getPath()));
        }
    }

    public static boolean checkDistributedInstallation() throws IOException {
        Properties props = new Properties();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("general.properties");
        props.load(in);
        return Boolean.parseBoolean(props.getProperty("distributed.installation"));
    }

    public static Object clone(Object obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream outObject = new ObjectOutputStream(out);
        outObject.writeObject(obj);
        byte[] bytes = out.toByteArray();
        byte[] clonedBytes = (byte[])bytes.clone();
        ByteArrayInputStream in = new ByteArrayInputStream(clonedBytes);
        ObjectInputStream inObject = new ObjectInputStream(in);
        return inObject.readObject();
    }

    public static List<String[]> readCSVFile(URI uri) throws IOException {
        CSVFileHelper helper = new CSVFileHelper(new File(uri));
        return helper.getData();
    }

    public static File getArtifactsRepo() {
        File artifactDirectory = new File(System.getProperty("java.io.tmpdir") + "/artifacts");
        if (!artifactDirectory.exists()) {
            if (artifactDirectory.mkdir()) {
                LOGGER.debug((Object)(artifactDirectory.getAbsoluteFile() + " directory correctly created"));
            } else {
                LOGGER.debug((Object)(artifactDirectory.getAbsoluteFile() + " directory not correctly created"));
            }
        }
        artifactDirectory.deleteOnExit();
        return artifactDirectory;
    }

    public static File getComponentsRepo() {
        File artifactDirectory = GeneralHelper.getArtifactsRepo();
        File componentDirectory = new File(artifactDirectory, "components");
        if (!componentDirectory.exists()) {
            if (componentDirectory.mkdir()) {
                LOGGER.debug((Object)(componentDirectory.getAbsoluteFile() + " directory correctly created"));
            } else {
                LOGGER.debug((Object)(componentDirectory.getAbsoluteFile() + " directory not correctly created"));
            }
        }
        componentDirectory.deleteOnExit();
        return componentDirectory;
    }

    public static File getServiceAssembliesRepo() {
        File artifactDirectory = GeneralHelper.getArtifactsRepo();
        File saDirectory = new File(artifactDirectory, "serviceassemblies");
        if (!saDirectory.exists()) {
            if (saDirectory.mkdir()) {
                LOGGER.debug((Object)(saDirectory.getAbsoluteFile() + " directory correctly created"));
            } else {
                LOGGER.debug((Object)(saDirectory.getAbsoluteFile() + " directory not correctly created"));
            }
        }
        saDirectory.deleteOnExit();
        return saDirectory;
    }

    public static File getSharedLibrariesRepo() {
        File artifactDirectory = GeneralHelper.getArtifactsRepo();
        File slDirectory = new File(artifactDirectory, "sharedlibraries");
        if (!slDirectory.exists()) {
            if (slDirectory.mkdir()) {
                LOGGER.debug((Object)(slDirectory.getAbsoluteFile() + " directory correctly created"));
            } else {
                LOGGER.debug((Object)(slDirectory.getAbsoluteFile() + " directory not correctly created"));
            }
        }
        slDirectory.deleteOnExit();
        return slDirectory;
    }

    public static File getOthersRepo() {
        File artifactDirectory = GeneralHelper.getArtifactsRepo();
        File othersDirectory = new File(artifactDirectory, "others");
        if (!othersDirectory.exists()) {
            if (othersDirectory.mkdir()) {
                LOGGER.debug((Object)(othersDirectory.getAbsoluteFile() + " directory correctly created"));
            } else {
                LOGGER.debug((Object)(othersDirectory.getAbsoluteFile() + " directory not correctly created"));
            }
        }
        othersDirectory.deleteOnExit();
        return othersDirectory;
    }

    public static File getAttachmentsRepo() {
        File artifactDirectory = GeneralHelper.getArtifactsRepo();
        File attachmentsDirectory = new File(artifactDirectory, "attachments");
        if (!attachmentsDirectory.exists()) {
            if (attachmentsDirectory.mkdir()) {
                LOGGER.debug((Object)(attachmentsDirectory.getAbsoluteFile() + " directory correctly created"));
            } else {
                LOGGER.debug((Object)(attachmentsDirectory.getAbsoluteFile() + " directory not correctly created"));
            }
        }
        attachmentsDirectory.deleteOnExit();
        return attachmentsDirectory;
    }

    public static void configureArtifact(File artifact) throws IOException {
        File directory = new File(artifact.getAbsolutePath().substring(0, artifact.getAbsolutePath().indexOf(".zip")));
        ZipHelper.decompress((String)artifact.getAbsolutePath(), (String)directory.getAbsolutePath(), (boolean)false);
        int[] permission = new int[]{7, 7, 7};
        for (File file : directory.listFiles()) {
            FilePermissionHelper.setRights((File)file, (int[])permission, (boolean)false);
        }
        if (!artifact.delete()) {
            LOGGER.warn((Object)("Unable to delete file: " + artifact.getPath()));
        }
        ZipHelper.compress((File[])directory.listFiles(), (File)artifact, (int)1);
        FilePermissionHelper.setRights((File)artifact, (int[])permission, (boolean)false);
        GeneralHelper.deleteFileTree((File)directory);
    }

    public static URL getFileRepositoryURL(String fileName, String artifactType, HttpServletRequest request) throws MalformedURLException, UnknownHostException {
        if (fileName != null) {
            File tmpFile;
            File componentDirectory = new File(System.getProperty("java.io.tmpdir") + "/artifacts/" + artifactType);
            if (componentDirectory.exists() && (tmpFile = new File(componentDirectory, fileName)).exists()) {
                StringBuilder urlBuilder = new StringBuilder();
                String requestURL = request.getRequestURL().toString();
                String[] parts = requestURL.split("/");
                urlBuilder.append(parts[0]).append("//").append(parts[2]).append(request.getSession().getServletContext().getContextPath()).append("/rest/artifacts/" + artifactType + "/").append(fileName);
                return new URL(urlBuilder.toString());
            }
        } else {
            LOGGER.warn((Object)("Filename cannot be null for search in repository filename parameter: " + fileName));
        }
        return null;
    }

    public static URL remoteComponentPackaged() throws URISyntaxException, IOException {
        return Thread.currentThread().getContextClassLoader().getResource("petals-se-rmi-1.2.0-SNAPSHOT.zip");
    }

    public static InputStream remoteComponentInputStream() throws URISyntaxException, IOException {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("petals-se-rmi-1.2.0-SNAPSHOT.zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block55: {
            LOGGER = LogFactory.getLog(GeneralHelper.class);
            InputStream in = null;
            try {
                in = GeneralHelper.remoteComponentInputStream();
                if (in == null) break block55;
                File componentDirectory = GeneralHelper.getComponentsRepo();
                File tmpFile = new File(componentDirectory, "petals-se-rmi-1.2.0-SNAPSHOT.zip");
                if (!tmpFile.exists()) {
                    try {
                        if (tmpFile.createNewFile()) {
                            LOGGER.info((Object)(tmpFile.getPath() + " file created"));
                        } else {
                            LOGGER.info((Object)(tmpFile.getPath() + " file not correctly created"));
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                tmpFile.deleteOnExit();
                OutputStream out = null;
                try {
                    LOGGER.debug((Object)("Begin to read " + tmpFile.getPath() + " file"));
                    out = new FileOutputStream(tmpFile);
                    byte[] data = new byte[1024];
                    while (in.read(data) > -1) {
                        out.write(data);
                    }
                    LOGGER.debug((Object)(tmpFile.getPath() + " file correctly read"));
                }
                catch (FileNotFoundException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    try {
                        out.flush();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    GeneralHelper.configureArtifact((File)tmpFile);
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                LOGGER.debug((Object)(tmpFile.getPath() + " file access rights configured"));
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

