/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.webconsole.utils;

import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.webconsole.utils.XMLPrettyPrinter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class StringHelper {
    private static final Log LOGGER = LogFactory.getLog(StringHelper.class);

    private StringHelper() {
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().equals("");
    }

    public static boolean isNotNullAndNotEmpty(String s) {
        return !StringHelper.isNullOrEmpty((String)s);
    }

    public static String createString(Source s) throws TransformerFactoryConfigurationError, IOException, TransformerException {
        String result = null;
        if (s instanceof StreamSource && ((StreamSource)s).getInputStream().markSupported()) {
            StreamSource ss = (StreamSource)s;
            ss.getInputStream().reset();
            byte[] buf = new byte[ss.getInputStream().available()];
            BufferedInputStream bis = new BufferedInputStream(ss.getInputStream());
            bis.read(buf);
            result = new String(buf);
            ss.getInputStream().reset();
            bis.close();
        } else {
            StringWriter buffer = new StringWriter();
            StreamResult sresult = new StreamResult(buffer);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(s, sresult);
            result = buffer.toString();
        }
        return result;
    }

    public static String prettyPrintWithSource(Source s) throws TransformerFactoryConfigurationError, IOException, TransformerException {
        return StringHelper.prettyPrint((String)StringHelper.createString((Source)s));
    }

    public static InputStreamForker fork(Source s) throws TransformerFactoryConfigurationError, IOException, TransformerException {
        String msg = StringHelper.prettyPrintWithSource((Source)s);
        byte[] msgByte = msg.getBytes("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(msgByte);
        return new InputStreamForker((InputStream)in);
    }

    public static Source createSource(String msg) throws UnsupportedEncodingException {
        StreamSource source = new StreamSource();
        byte[] msgByte = msg.getBytes("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(msgByte);
        source.setInputStream(in);
        return source;
    }

    public static String parseToString(Node node) throws TransformerFactoryConfigurationError, TransformerException {
        String result = null;
        if (node != null) {
            node.normalize();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
            StringBuffer buffer = stringWriter.getBuffer();
            result = buffer.toString();
        }
        return result;
    }

    public static String prettyPrint(String xmlResponse) {
        String result = xmlResponse;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.newDocumentBuilder();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xmlResponse));
            Document document = parser.parse(is);
            result = StringHelper.prettyPrint((Document)document);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)"Error occurred during xml response pretty printing", (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error((Object)"Error occurred during xml response pretty printing", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error occurred during xml response pretty printing", (Throwable)e);
        }
        return result;
    }

    public static String prettyPrint(Document xmlDocument) {
        String result = null;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            XMLPrettyPrinter.prettify((Node)xmlDocument, (OutputStream)outStream);
        }
        catch (TransformerException e) {
            result = "";
        }
        try {
            result = outStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result = "";
        }
        return result;
    }

    public static String htmlEncoder(String response) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < response.length(); ++i) {
            char c = response.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                buf.append(c);
                continue;
            }
            if (c == '\r' && response.charAt(i + 1) == '\n') {
                buf.append("<br />");
                continue;
            }
            if (c == ' ') {
                buf.append("&nbsp;");
                continue;
            }
            buf.append("&#" + c + ";");
        }
        return buf.toString();
    }
}

