/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.rest.impl;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.management.deployment.AtomicDeploymentService;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.service.RESTService;
import org.petalslink.dsb.kernel.rest.api.ServiceAssembly;
import org.petalslink.dsb.kernel.rest.api.beans.SA;
import org.petalslink.dsb.kernel.rest.api.beans.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RESTService
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ServiceAssembly.class)})
public class ServiceAssemblyServiceImpl
implements BindingController,
LifeCycleController,
ServiceAssembly {
    private static final Status OK = new Status("OK");
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="atomic-deployment", signature=AtomicDeploymentService.class)
    protected AtomicDeploymentService atomicDeploymentService;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.start();
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Status start(String string) {
        if (string == null) {
            return new Status("Null SA name");
        }
        try {
            this.atomicDeploymentService.start(string);
        }
        catch (PetalsException petalsException) {
            return new Status(petalsException.getMessage());
        }
        return OK;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public Status stop(String string) {
        if (string == null) {
            return new Status("Null SA name");
        }
        try {
            this.atomicDeploymentService.stop(string);
        }
        catch (PetalsException petalsException) {
            return new Status(petalsException.getMessage());
        }
        return OK;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public Status shutdown(String string) {
        if (string == null) {
            return new Status("Null SA name");
        }
        try {
            this.atomicDeploymentService.shutdown(string);
        }
        catch (PetalsException petalsException) {
            return new Status(petalsException.getMessage());
        }
        return OK;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public Status status(String string) {
        return new Status("TODO");
    }

    @Override
    public Status undeploy(String string) {
        return new Status("TODO");
    }

    @Override
    public List<SA> all() {
        ArrayList<SA> arrayList = new ArrayList<SA>();
        SA sA = new SA();
        sA.setName("SA-1");
        sA.setState("started");
        SA sA2 = new SA();
        sA2.setName("SA-2");
        sA2.setState("stopped");
        arrayList.add(sA);
        arrayList.add(sA2);
        return arrayList;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("atomic-deployment")) {
            if (!AtomicDeploymentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AtomicDeploymentService.class.getName());
            }
            this.atomicDeploymentService = (AtomicDeploymentService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("atomic-deployment");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("atomic-deployment")) {
            return this.atomicDeploymentService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("atomic-deployment")) {
            this.atomicDeploymentService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

