/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.generic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.util.InputStreamForker;
import org.ow2.easywsdl.wsdl.util.WSDLVersionDetector;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLReaderImpl
extends AbstractWSDLReaderImpl
implements WSDLReader {
    private final List<Class> addedObjectFactories;
    private static final Logger log = Logger.getLogger(WSDLReaderImpl.class.getName());
    private final AbstractWSDLReaderImpl reader11;
    private final AbstractWSDLReaderImpl reader20;

    public WSDLReaderImpl() throws WSDLException {
        this(null);
    }

    public WSDLReaderImpl(List<Class> addedObjectFactories) throws WSDLException {
        this.addedObjectFactories = addedObjectFactories;
        this.reader11 = new org.ow2.easywsdl.wsdl.impl.wsdl11.WSDLReaderImpl(this.addedObjectFactories);
        this.reader20 = new org.ow2.easywsdl.wsdl.impl.wsdl20.WSDLReaderImpl(this.addedObjectFactories);
    }

    @Override
    public Description read(URL wsdlURL) throws WSDLException, MalformedURLException, IOException, URISyntaxException {
        try {
            InputSource inputSource = new InputSource(wsdlURL.openStream());
            inputSource.setSystemId(wsdlURL.toString());
            AbsItfDescription.WSDLVersionConstants version = WSDLVersionDetector.getVersion(inputSource);
            inputSource = new InputSource(wsdlURL.openStream());
            inputSource.setSystemId(wsdlURL.toString());
            return this.read(version, inputSource, null, null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("The provided well-formed URL has been detected as malformed !!");
        }
    }

    @Override
    public Description read(InputSource source, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports) throws WSDLException, MalformedURLException, URISyntaxException {
        return this.read(source, descriptionImports, schemaImports, true);
    }

    @Override
    public Description read(InputSource inputSource, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports, boolean deleteImports) throws WSDLException, MalformedURLException, URISyntaxException {
        if (inputSource.getByteStream() != null) {
            String systemId = inputSource.getSystemId();
            if (systemId != null) {
                this.setDocumentBaseURI(new URI(systemId));
            }
            InputStream originalInputStream = inputSource.getByteStream();
            InputStreamForker isf = new InputStreamForker(originalInputStream);
            inputSource.setByteStream(isf.getInputStreamOne());
            AbsItfDescription.WSDLVersionConstants version = null;
            try {
                DOMSource source = SourceHelper.convertInputSource2DOMSource(inputSource);
                version = WSDLVersionDetector.getVersion((Document)source.getNode());
            }
            catch (XmlException e) {
                throw new WSDLException(e);
            }
            inputSource.setByteStream(isf.getInputStreamTwo());
            return this.read(version, inputSource, descriptionImports, schemaImports, deleteImports);
        }
        throw new UnsupportedOperationException("This method supports only InputSource with byte stream.");
    }

    private Description read(AbsItfDescription.WSDLVersionConstants version, InputSource source, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports) throws WSDLException, MalformedURLException, URISyntaxException {
        return this.read(version, source, descriptionImports, schemaImports, true);
    }

    private Description read(AbsItfDescription.WSDLVersionConstants version, InputSource source, Map<URI, AbsItfDescription> descriptionImports, Map<URI, AbsItfSchema> schemaImports, boolean deleteImports) throws WSDLException, MalformedURLException, URISyntaxException {
        AbstractWSDLReaderImpl reader;
        if (version == AbsItfDescription.WSDLVersionConstants.WSDL11) {
            reader = this.reader11;
        } else if (version == AbsItfDescription.WSDLVersionConstants.WSDL20) {
            reader = this.reader20;
        } else {
            throw new WSDLException("unknown version of wsdl");
        }
        reader.setFeatures(this.getFeatures());
        return reader.read(source, descriptionImports, schemaImports, deleteImports);
    }

    @Override
    public Description read(Document document) throws WSDLException, URISyntaxException {
        try {
            AbsItfDescription.WSDLVersionConstants version = WSDLVersionDetector.getVersion(document);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(baos);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), streamResult);
            baos.flush();
            baos.close();
            InputSource documentInputSource = new InputSource(new ByteArrayInputStream(baos.toByteArray()));
            documentInputSource.setSystemId(document.getBaseURI());
            return this.read(version, documentInputSource, null, null, true);
        }
        catch (TransformerConfigurationException e) {
            throw new WSDLException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new WSDLException(e);
        }
        catch (TransformerException e) {
            throw new WSDLException(e);
        }
        catch (IOException e) {
            throw new WSDLException(e);
        }
    }

    @Override
    public Description read(InputSource inputSource) throws WSDLException, MalformedURLException, URISyntaxException {
        return this.read(inputSource, null, null, true);
    }
}

