/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import org.objectweb.fractal.adl.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeUtil {
    private NodeUtil() {
    }

    public static <T> T castNode(Object node, Class<T> nodeClass) {
        try {
            return nodeClass.cast(node);
        }
        catch (ClassCastException e) {
            throw new InvalidNodeTypeException(node, nodeClass);
        }
    }

    public static <T> T castNodeError(Object node, Class<T> nodeClass) {
        try {
            return nodeClass.cast(node);
        }
        catch (ClassCastException e) {
            throw new InvalidNodeTypeError(node, nodeClass);
        }
    }

    private static String getErrorMessage(Object node, Class<?> nodeClass) {
        StringBuilder sb = new StringBuilder("The given node does not implement the expected type.");
        sb.append(" Expected type: '").append(nodeClass.getName()).append("'.");
        if (node instanceof Node) {
            sb.append(" Node location: '").append(((Node)node).astGetSource()).append("'.");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvalidNodeTypeError
    extends Error {
        InvalidNodeTypeError(Object node, Class<?> nodeClass) {
            super(NodeUtil.getErrorMessage(node, nodeClass));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvalidNodeTypeException
    extends ClassCastException {
        InvalidNodeTypeException(Object node, Class<?> nodeClass) {
            super(NodeUtil.getErrorMessage(node, nodeClass));
        }
    }
}

