/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.merger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.NodeClassLoader;
import org.objectweb.fractal.adl.merger.MergeException;
import org.objectweb.fractal.adl.merger.MergeableDecoration;
import org.objectweb.fractal.adl.merger.NodeMerger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMergerImpl
implements NodeMerger {
    private final MergeClassLoader mergeClassLoader;
    private final Map<Class<?>, Map<String, SubNodeArity>> subNodeArityCache = new IdentityHashMap();

    public NodeMergerImpl() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        this.mergeClassLoader = new MergeClassLoader(classLoader);
    }

    @Override
    public Node merge(Node elem, Node superElem, Map<String, String> idAttributes) throws MergeException {
        HashMap<Node, MergeInfo> infos = new HashMap<Node, MergeInfo>();
        MergeInfo elemInfo = this.computeMergeInfos(elem, superElem, infos, idAttributes);
        for (MergeInfo info : infos.values()) {
            info.createResultNode(this.mergeClassLoader);
        }
        Node n = this.initMergedNodes(elemInfo, infos);
        return n;
    }

    private MergeInfo computeMergeInfos(Node elem, Node superElem, Map<Node, MergeInfo> infos, Map<String, String> idAttributes) throws MergeException {
        MergeInfo info = infos.get(elem);
        if (info == null) {
            info = infos.get(superElem);
            if (info != null) {
                info.resetElem(elem);
            } else {
                info = new MergeInfo(elem);
                info.addSuperNode(superElem);
                infos.put(superElem, info);
            }
            infos.put(elem, info);
        } else if (info.addSuperNode(superElem)) {
            infos.put(superElem, info);
        } else {
            return info;
        }
        HashSet<String> nodeTypes = new HashSet<String>();
        nodeTypes.addAll(Arrays.asList(elem.astGetNodeTypes()));
        nodeTypes.addAll(Arrays.asList(superElem.astGetNodeTypes()));
        for (String nodeType : nodeTypes) {
            SubNodeArity arity;
            Node[] superNodes = superElem.astGetNodes(nodeType);
            Node[] nodes = elem.astGetNodes(nodeType);
            if ((superNodes == null || superNodes.length == 0) && (nodes == null || nodes.length == 0)) continue;
            if (superNodes == null) {
                superNodes = new Node[]{};
            }
            if (nodes == null) {
                nodes = new Node[]{};
            }
            if ((arity = this.checkArityCompatibility(elem, superElem, nodeType)) == SubNodeArity.ONE) {
                assert (superNodes.length <= 1);
                assert (nodes.length <= 1);
                if (superNodes.length > 0 && superNodes[0] != null) {
                    if (nodes.length == 0 || nodes[0] == null) {
                        info.addSubNodeInfo(this.computeMergeInfos(superNodes[0], infos));
                        continue;
                    }
                    info.addSubNodeInfo(this.computeMergeInfos(nodes[0], superNodes[0], infos, idAttributes));
                    continue;
                }
                if (nodes.length <= 0 || nodes[0] == null) continue;
                info.addSubNodeInfo(this.computeMergeInfos(nodes[0], infos));
                continue;
            }
            String nameAttr = idAttributes.get(nodeType);
            if (nameAttr == null) {
                for (Node n : superNodes) {
                    info.addSubNodeInfo(this.computeMergeInfos(n, infos));
                }
                for (Node n : nodes) {
                    info.addSubNodeInfo(this.computeMergeInfos(n, infos));
                }
                continue;
            }
            block3: for (Node superNode : superNodes) {
                String superName = superNode.astGetAttributes().get(nameAttr);
                if (superName == null) {
                    throw new MergeException("The attribute '" + nameAttr + "' cannot be null", superNode);
                }
                for (Node node : nodes) {
                    String name = node.astGetAttributes().get(nameAttr);
                    if (name == null) {
                        throw new MergeException("The attribute '" + nameAttr + "' cannot be null", node);
                    }
                    if (!name.equals(superName)) continue;
                    info.addSubNodeInfo(this.computeMergeInfos(node, superNode, infos, idAttributes));
                    continue block3;
                }
                info.addSubNodeInfo(this.computeMergeInfos(superNode, infos));
            }
            block5: for (Node node : nodes) {
                String name = node.astGetAttributes().get(nameAttr);
                for (Node superNode : superNodes) {
                    String superName = superNode.astGetAttributes().get(nameAttr);
                    if (name.equals(superName)) continue block5;
                }
                info.addSubNodeInfo(this.computeMergeInfos(node, infos));
            }
        }
        return info;
    }

    private MergeInfo computeMergeInfos(Node node, Map<Node, MergeInfo> infos) throws MergeException {
        MergeInfo info = infos.get(node);
        if (info == null) {
            info = new MergeInfo(node);
            infos.put(node, info);
            for (String type : node.astGetNodeTypes()) {
                for (Node subNode : node.astGetNodes(type)) {
                    if (subNode == null) continue;
                    info.addSubNodeInfo(this.computeMergeInfos(subNode, infos));
                }
            }
        }
        return info;
    }

    private Node initMergedNodes(MergeInfo info, Map<Node, MergeInfo> infos) throws MergeException {
        if (info.done) {
            return info.result;
        }
        info.done = true;
        Node elem = info.elem;
        Node result = info.result;
        result.astSetSource(elem.astGetSource());
        Map<String, String> resultAttrs = elem.astGetAttributes();
        for (Node superNode : info.getSuperNodes()) {
            for (Map.Entry<String, String> entry : superNode.astGetAttributes().entrySet()) {
                String name = entry.getKey();
                String superValue = entry.getValue();
                String value = resultAttrs.get(name);
                if (superValue == null || value != null) continue;
                resultAttrs.put(name, superValue);
            }
        }
        result.astSetAttributes(resultAttrs);
        Map<String, Object> resultDecors = elem.astGetDecorations();
        for (Node superNode : info.getSuperNodes()) {
            for (Map.Entry<String, Object> entry : superNode.astGetDecorations().entrySet()) {
                String name = entry.getKey();
                Object superValue = entry.getValue();
                Object value = resultDecors.get(name);
                if (superValue instanceof MergeableDecoration) {
                    resultDecors.put(name, ((MergeableDecoration)superValue).mergeDecoration(value));
                    continue;
                }
                if (superValue == null || value != null) continue;
                resultDecors.put(name, superValue);
            }
        }
        result.astSetDecorations(resultDecors);
        for (MergeInfo subNodeInfo : info.getSubNodeInfos()) {
            result.astAddNode(this.initMergedNodes(subNodeInfo, infos));
        }
        return info.result;
    }

    private SubNodeArity getSubNodeArity(Node node, String subNodeType) {
        SubNodeArity arity;
        Class<?> nodeClass = node.getClass();
        Map<String, SubNodeArity> arities = this.subNodeArityCache.get(nodeClass);
        if (arities == null) {
            arities = new HashMap<String, SubNodeArity>();
            this.subNodeArityCache.put(nodeClass, arities);
        }
        if ((arity = arities.get(subNodeType)) == null) {
            try {
                nodeClass.getMethod("get" + Character.toUpperCase(subNodeType.charAt(0)) + subNodeType.substring(1), new Class[0]);
                arity = SubNodeArity.ONE;
            }
            catch (Exception e) {
                try {
                    nodeClass.getMethod("get" + Character.toUpperCase(subNodeType.charAt(0)) + subNodeType.substring(1) + 's', new Class[0]);
                    arity = SubNodeArity.MANY;
                }
                catch (Exception e1) {
                    arity = SubNodeArity.NONE;
                }
            }
            arities.put(subNodeType, arity);
        }
        return arity;
    }

    private SubNodeArity checkArityCompatibility(Node node, Node superNode, String subNodeType) throws MergeException {
        SubNodeArity nodeArity = this.getSubNodeArity(node, subNodeType);
        if (node.getClass() == superNode.getClass()) {
            assert (nodeArity != SubNodeArity.NONE);
            return nodeArity;
        }
        SubNodeArity superNodeArity = this.getSubNodeArity(superNode, subNodeType);
        if (nodeArity == SubNodeArity.NONE) {
            assert (superNodeArity != SubNodeArity.NONE);
            return superNodeArity;
        }
        if (superNodeArity == SubNodeArity.NONE) {
            return nodeArity;
        }
        if (nodeArity != superNodeArity) {
            throw new MergeException("Cannot merge AST, the arity of sub nodes of type '" + subNodeType + "' is not the same for node '" + node.astGetSource() + "' and node '" + superNode.astGetSource() + "'. Check DTDs");
        }
        return nodeArity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MergeClassLoader
    extends NodeClassLoader {
        MergeClassLoader(ClassLoader parent) {
            super(parent);
        }

        Class<?> mergeNodeClasses(String astNodeName, Node elem, Set<Node> superNodes) throws ClassNotFoundException {
            int hash = elem.getClass().hashCode();
            for (Node superNode : superNodes) {
                hash = 17 * (hash + superNode.getClass().hashCode());
            }
            String name = "org.objectweb.fractal.adl.merged.Merged" + Integer.toHexString(hash);
            try {
                return this.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                HashSet<String> itfs = new HashSet<String>();
                for (Class<?> itf : elem.getClass().getInterfaces()) {
                    itfs.add(Type.getInternalName(itf));
                }
                for (Node superNode : superNodes) {
                    for (Class<?> itf : superNode.getClass().getInterfaces()) {
                        itfs.add(Type.getInternalName(itf));
                    }
                }
                ClassWriter cw = this.generateClass(name, astNodeName, Type.getInternalName(AbstractNode.class), itfs.toArray(new String[itfs.size()]));
                return this.defineClass(name, cw.toByteArray());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MergeInfo {
        Node elem;
        Set<Node> superNodes;
        Node result;
        List<MergeInfo> subNodeInfos = new ArrayList<MergeInfo>();
        boolean done;
        boolean uniqueNodeClassLoader = true;

        MergeInfo(Node elem) {
            assert (elem != null);
            this.elem = elem;
        }

        void resetElem(Node newElem) {
            assert (newElem != null);
            assert (this.elem != null);
            Node oldElem = this.elem;
            this.elem = newElem;
            if (this.superNodes != null) {
                Set<Node> oldSuperNodes = this.superNodes;
                this.superNodes = new LinkedHashSet<Node>();
                this.superNodes.add(oldElem);
                this.superNodes.addAll(oldSuperNodes);
            } else {
                this.superNodes = new LinkedHashSet<Node>();
                this.superNodes.add(oldElem);
            }
            if (this.uniqueNodeClassLoader && newElem.getClass().getClassLoader() != oldElem.getClass().getClassLoader()) {
                this.uniqueNodeClassLoader = false;
            }
        }

        boolean addSuperNode(Node superNode) {
            assert (superNode != null);
            if (this.superNodes == null) {
                this.superNodes = new LinkedHashSet<Node>();
            }
            if (superNode.getClass().getClassLoader() != this.elem.getClass().getClassLoader()) {
                this.uniqueNodeClassLoader = false;
            }
            return this.superNodes.add(superNode);
        }

        Set<Node> getSuperNodes() {
            if (this.superNodes == null) {
                return Collections.EMPTY_SET;
            }
            return this.superNodes;
        }

        void addSubNodeInfo(MergeInfo subNodeInfo) {
            assert (subNodeInfo != null);
            if (this.subNodeInfos == null) {
                this.subNodeInfos = new ArrayList<MergeInfo>();
            }
            this.subNodeInfos.add(subNodeInfo);
        }

        List<MergeInfo> getSubNodeInfos() {
            if (this.subNodeInfos == null) {
                return Collections.EMPTY_LIST;
            }
            return this.subNodeInfos;
        }

        void createResultNode(MergeClassLoader mergeClassLoader) throws MergeException {
            if (this.uniqueNodeClassLoader) {
                try {
                    this.result = (Node)this.elem.getClass().newInstance();
                }
                catch (Exception e) {
                    throw new MergeException("Cannot merge ASTs", this.elem, e);
                }
            }
            try {
                Class<?> merged = mergeClassLoader.mergeNodeClasses(this.elem.astGetType(), this.elem, this.superNodes);
                this.result = (Node)merged.newInstance();
            }
            catch (Exception e) {
                throw new MergeException("Cannot merge AST classes", this.elem, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubNodeArity {
        ONE,
        MANY,
        NONE;

    }
}

