/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitor.router;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jbi.messaging.MessageExchange;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.tools.monitoring.to.Role;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.monitor.router.MonitoringModule;
import org.petalslink.dsb.kernel.monitor.router.MonitoringStorageService;
import org.petalslink.dsb.kernel.monitor.router.RouterMonitorImpl;
import org.petalslink.dsb.kernel.monitor.util.BufferedLinkedBlockingQueue;
import org.petalslink.dsb.kernel.monitor.util.TOConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RouterService.class)})
public class MonitoringModuleImpl
extends RouterMonitorImpl
implements BindingController,
LifeCycleController,
MonitoringModule {
    @Requires(name="storageService", signature=MonitoringStorageService.class)
    private MonitoringStorageService storageService;

    @Override
    public long getExchangeDuration(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The 'timestamp' parameter must not be null ");
        }
        ExchangeContext exchangeContext = this.storageService.getExchangeContext(string);
        if (exchangeContext != null) {
            return exchangeContext.getTimestamp().getTime() - exchangeContext.getTimestamp().getTime();
        }
        return 0L;
    }

    @Override
    public String getFcState() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.ow2.petals.tools.monitoring.to.MessageExchange getMessageExchange(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The 'timestamp' parameter must not be null ");
        }
        BufferedLinkedBlockingQueue<ExchangeContext> bufferedLinkedBlockingQueue = this.storageService.getStorage();
        synchronized (bufferedLinkedBlockingQueue) {
            ExchangeContext[] exchangeContextArray = this.storageService.getStorage().toArray(new ExchangeContext[this.storageService.getStorage().size()]);
            if (exchangeContextArray != null && exchangeContextArray.length > 0) {
                ExchangeContext[] exchangeContextArray2 = exchangeContextArray;
                int n = exchangeContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExchangeContext exchangeContext = exchangeContextArray2[n2];
                    if (exchangeContext.getTimestamp().equals(date)) {
                        return exchangeContext.getExchange();
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    @Override
    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public List<org.ow2.petals.tools.monitoring.to.MessageExchange> getMessageExchanges(Date date, Date date2) {
        List<org.ow2.petals.tools.monitoring.to.MessageExchange> list;
        block7: {
            list = Collections.synchronizedList(new ArrayList());
            ExchangeContext[] exchangeContextArray = this.storageService.getStorage().toArray(new ExchangeContext[this.storageService.getStorage().size()]);
            if (exchangeContextArray == null || exchangeContextArray.length <= 0) break block7;
            if (date == null && date2 == null) {
                ExchangeContext[] exchangeContextArray2 = exchangeContextArray;
                int n = exchangeContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExchangeContext exchangeContext = exchangeContextArray2[n2];
                    list.add(exchangeContext.getExchange());
                    ++n2;
                }
            } else {
                if (date == null) {
                    throw new IllegalArgumentException("The 'begin' parameter must not be null if 'ending' parameter is null too ");
                }
                if (date2 == null) {
                    throw new IllegalArgumentException("The 'ending' parameter must not be null if 'begin' parameter is null too ");
                }
                ExchangeContext[] exchangeContextArray3 = exchangeContextArray;
                int n = exchangeContextArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ExchangeContext exchangeContext = exchangeContextArray3[n3];
                    if (exchangeContext.getTimestamp().getTime() > date.getTime() && exchangeContext.getTimestamp().getTime() < date2.getTime()) {
                        list.add(exchangeContext.getExchange());
                    }
                    ++n3;
                }
            }
        }
        return list;
    }

    @Override
    public org.ow2.petals.tools.monitoring.to.MessageExchange getMessageExchange(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The 'exchangeId' parameter must not be null ");
        }
        ExchangeContext exchangeContext = this.storageService.getExchangeContext(string);
        if (exchangeContext != null) {
            return exchangeContext.getExchange();
        }
        return null;
    }

    @Override
    public String getConsumer(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The 'exchangeId' parameter must not be null ");
        }
        ExchangeContext exchangeContext = this.storageService.getExchangeContext(string);
        if (exchangeContext != null) {
            return exchangeContext.getConsumer();
        }
        return null;
    }

    @Override
    public String getProvider(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The 'exchangeId' parameter must not be null ");
        }
        ExchangeContext exchangeContext = this.storageService.getExchangeContext(string);
        if (exchangeContext != null) {
            return exchangeContext.getProvider();
        }
        return null;
    }

    public void removeMessageExchange(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The 'exchangeId' parameter must not be null ");
        }
        this.storageService.getStorage().remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMessageExchange(ComponentContext componentContext, org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange, Date date) {
        if (messageExchange == null) {
            throw new IllegalArgumentException("The 'exchange' parameter must not be null ");
        }
        ExchangeContext exchangeContext = new ExchangeContext();
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        calendar.setTime(date);
        messageExchange.setTimestamp(String.valueOf(simpleDateFormat.format(date)) + "." + calendar.get(14));
        exchangeContext.setTimestamp(date);
        exchangeContext.setExchange(messageExchange);
        if (messageExchange.getRole().equals(Role.CONSUMER)) {
            exchangeContext.setConsumer(componentContext.getComponentName());
        } else if (messageExchange.getRole().equals(Role.PROVIDER)) {
            exchangeContext.setProvider(componentContext.getComponentName());
        }
        BufferedLinkedBlockingQueue<ExchangeContext> bufferedLinkedBlockingQueue = this.storageService.getStorage();
        synchronized (bufferedLinkedBlockingQueue) {
            try {
                this.storageService.getStorage().put(exchangeContext);
            }
            catch (InterruptedException interruptedException) {
                this.log.info((Object)("[Error occured during the storage message exchange in the monitoring module]: " + interruptedException.getMessage()));
            }
        }
    }

    public void updateMessageExchange(ComponentContext componentContext, org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange, Date date) {
        if (messageExchange == null) {
            throw new IllegalArgumentException("The 'exchange' parameter must not be null ");
        }
        this.removeMessageExchange(messageExchange.getExchangeId());
        this.storeMessageExchange(componentContext, messageExchange, date);
    }

    @Override
    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("router")) {
            if (!RouterService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterService.class.getName());
            }
            this.router = (RouterService)object;
            return;
        }
        if (string.equals("storageService")) {
            if (!MonitoringStorageService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + MonitoringStorageService.class.getName());
            }
            this.storageService = (MonitoringStorageService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void addComponent(ComponentContext componentContext) throws RoutingException {
        super.addComponent(componentContext);
    }

    @Override
    public void modifiedSALifeCycle(List<ServiceUnitLifeCycle> list) {
        super.modifiedSALifeCycle(list);
    }

    @Override
    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("router");
        arrayList.add("storageService");
        return arrayList.toArray(new String[0]);
    }

    @Override
    public org.ow2.petals.jbi.messaging.exchange.MessageExchange receive(ComponentContext componentContext, long l) throws RoutingException {
        MessageExchangeImpl messageExchangeImpl = (MessageExchangeImpl)this.router.receive(componentContext, l);
        if (messageExchangeImpl != null) {
            this.report((org.ow2.petals.jbi.messaging.exchange.MessageExchange)messageExchangeImpl, this.logger, componentContext);
        }
        return messageExchangeImpl;
    }

    @Override
    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("router")) {
            return this.router;
        }
        if (string.equals("storageService")) {
            return this.storageService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void removeComponent(ComponentContext componentContext) throws RoutingException {
        super.removeComponent(componentContext);
    }

    @Override
    public void send(ComponentContext componentContext, org.ow2.petals.jbi.messaging.exchange.MessageExchange messageExchange) throws RoutingException {
        if (messageExchange != null) {
            this.report(messageExchange, this.logger, componentContext);
        }
        this.router.send(componentContext, messageExchange);
    }

    @Override
    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("router")) {
            this.router = null;
            return;
        }
        if (string.equals("storageService")) {
            this.storageService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public org.ow2.petals.jbi.messaging.exchange.MessageExchange sendSync(ComponentContext componentContext, org.ow2.petals.jbi.messaging.exchange.MessageExchange messageExchange, long l) throws RoutingException {
        this.report(messageExchange, this.logger, componentContext);
        MessageExchangeImpl messageExchangeImpl = (MessageExchangeImpl)this.router.sendSync(componentContext, messageExchange, l);
        if (messageExchangeImpl != null) {
            this.report((org.ow2.petals.jbi.messaging.exchange.MessageExchange)messageExchangeImpl, this.logger, componentContext);
        }
        return messageExchangeImpl;
    }

    private void report(org.ow2.petals.jbi.messaging.exchange.MessageExchange messageExchange, Logger logger, ComponentContext componentContext) {
        org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange2 = null;
        if (messageExchange != null) {
            try {
                messageExchange2 = TOConverter.convert((MessageExchange)messageExchange, this.logger);
            }
            catch (SecurityException securityException) {
                this.log.info((Object)("[Error occured during the role conversion in the monitoring module]: " + securityException.getMessage()));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.log.info((Object)("[Error occured during the role conversion in the monitoring module]: " + noSuchFieldException.getMessage()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.info((Object)("[Error occured during the role conversion in the monitoring module]: " + illegalArgumentException.getMessage()));
            }
            catch (IllegalAccessException illegalAccessException) {
                this.log.info((Object)("[Error occured during the role conversion in the monitoring module]: " + illegalAccessException.getMessage()));
            }
            catch (IOException iOException) {
                this.log.info((Object)("[Error occured during the role conversion in the monitoring module]: " + iOException.getMessage()));
            }
            catch (RoutingException routingException) {
                this.log.info((Object)("[Error occured during the role conversion in the monitoring module]: " + routingException.getMessage()));
            }
        }
        if (messageExchange2 != null) {
            ExchangeContext exchangeContext = this.storageService.getExchangeContext(messageExchange2.getExchangeId());
            if (exchangeContext != null) {
                this.removeMessageExchange(messageExchange2.getExchangeId());
                if (exchangeContext.getExchange().getIn() != null) {
                    messageExchange2.setIn(exchangeContext.getExchange().getIn());
                }
                if (exchangeContext.getExchange().getOut() != null) {
                    messageExchange2.setOut(exchangeContext.getExchange().getOut());
                }
                if (exchangeContext.getExchange().getFault() != null) {
                    messageExchange2.setFault(exchangeContext.getExchange().getFault());
                }
                this.storeMessageExchange(componentContext, messageExchange2, Calendar.getInstance().getTime());
            } else {
                this.storeMessageExchange(componentContext, messageExchange2, Calendar.getInstance().getTime());
            }
        }
    }

    public void startTraffic() {
    }

    @Override
    public void stopTraffic() {
        super.stopTraffic();
    }

    @Override
    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        super.start();
        this.log = new LoggingUtil(this.logger);
        this.log.call();
    }

    @Override
    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws Exception {
        super.stop();
        this.log.call();
    }

    public static class ExchangeContext {
        private org.ow2.petals.tools.monitoring.to.MessageExchange exchange;
        private Date timestamp;
        private String provider;
        private String consumer;

        public ExchangeContext(Date date, String string, org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange, String string2) {
            this.timestamp = date;
            this.consumer = string;
            this.exchange = messageExchange;
            this.provider = string2;
        }

        public ExchangeContext() {
        }

        public org.ow2.petals.tools.monitoring.to.MessageExchange getExchange() {
            return this.exchange;
        }

        public void setExchange(org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange) {
            this.exchange = messageExchange;
        }

        public String getProvider() {
            return this.provider;
        }

        public void setProvider(String string) {
            this.provider = string;
        }

        public String getConsumer() {
            return this.consumer;
        }

        public void setConsumer(String string) {
            this.consumer = string;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Date date) {
            this.timestamp = date;
        }
    }
}

