/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitor.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.tools.monitoring.to.ExchangeStatus;
import org.ow2.petals.tools.monitoring.to.NormalizedMessage;
import org.ow2.petals.tools.monitoring.to.Property;
import org.ow2.petals.tools.monitoring.to.Role;
import org.petalslink.dsb.kernel.monitor.util.MonitoringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TOConverter {
    public static org.ow2.petals.tools.monitoring.to.MessageExchange convert(MessageExchange messageExchange, Logger logger) throws IOException, IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException, RoutingException {
        org.ow2.petals.tools.monitoring.to.MessageExchange messageExchange2 = new org.ow2.petals.tools.monitoring.to.MessageExchange();
        org.ow2.petals.tools.monitoring.to.ServiceEndpoint serviceEndpoint = TOConverter.convert((ServiceEndpoint)messageExchange.getEndpoint());
        messageExchange2.setEndpoint(serviceEndpoint);
        messageExchange2.setExchangeId(messageExchange.getExchangeId());
        if (messageExchange.getInterfaceName() != null) {
            messageExchange2.setInterfaceName(messageExchange.getInterfaceName().toString());
        }
        if (messageExchange.getOperation() != null) {
            messageExchange2.setOperation(messageExchange.getOperation().toString());
        }
        messageExchange2.setPattern(MonitoringUtil.splitPattern(messageExchange.getPattern()));
        messageExchange2.setRole(TOConverter.convert(messageExchange.getRole()));
        if (messageExchange.getService() != null) {
            messageExchange2.setService(messageExchange.getService().toString());
        }
        messageExchange2.setStatus(TOConverter.convert(messageExchange.getStatus()));
        messageExchange2.setProperties(TOConverter.getProperties(messageExchange));
        MessageExchangeImpl messageExchangeImpl = (MessageExchangeImpl)messageExchange;
        if (messageExchangeImpl.getConsumerEndpoint() != null && messageExchangeImpl.getConsumerEndpoint().getLocation() != null) {
            messageExchange2.setConsumer(messageExchangeImpl.getConsumerEndpoint().getLocation().getComponentName());
        }
        if (messageExchange.getEndpoint() != null && ((ServiceEndpoint)messageExchange.getEndpoint()).getLocation() != null) {
            messageExchange2.setProvider(((ServiceEndpoint)messageExchange.getEndpoint()).getLocation().getComponentName());
        }
        if (messageExchange.getError() != null) {
            messageExchange2.setError(TOConverter.marshalError(messageExchange.getError()));
        }
        if (messageExchange.getFault() != null) {
            messageExchange2.setFault(TOConverter.convert((javax.jbi.messaging.NormalizedMessage)messageExchange.getFault(), logger));
        }
        if (messageExchange.getMessage("IN") != null) {
            messageExchange2.setIn(TOConverter.convert(messageExchange.getMessage("IN"), logger));
        }
        if (messageExchange.getMessage("OUT") != null) {
            messageExchange2.setOut(TOConverter.convert(messageExchange.getMessage("OUT"), logger));
        }
        return messageExchange2;
    }

    public static List<Property> getProperties(MessageExchange messageExchange) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        Set set = messageExchange.getPropertyNames();
        if (set != null) {
            Object[] objectArray = set.toArray();
            int n = 0;
            while (n < objectArray.length) {
                String string = (String)objectArray[n];
                Property property = null;
                property = messageExchange.getProperty(string) != null ? new Property(string, messageExchange.getProperty(string).toString()) : new Property(string, null);
                arrayList.add(property);
                ++n;
            }
        }
        return arrayList;
    }

    public static ExchangeStatus convert(javax.jbi.messaging.ExchangeStatus exchangeStatus) {
        ExchangeStatus exchangeStatus2 = new ExchangeStatus();
        exchangeStatus2.setStatus(exchangeStatus.toString());
        return exchangeStatus2;
    }

    public static Role convert(MessageExchange.Role role) throws IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
        if (role != null) {
            if (MessageExchange.Role.CONSUMER.equals(role)) {
                return Role.CONSUMER;
            }
            if (MessageExchange.Role.PROVIDER.equals(role)) {
                return Role.PROVIDER;
            }
        }
        return null;
    }

    public static NormalizedMessage convert(javax.jbi.messaging.NormalizedMessage normalizedMessage, Logger logger) {
        Object object;
        NormalizedMessage normalizedMessage2 = new NormalizedMessage();
        if (normalizedMessage.getContent() != null) {
            try {
                object = MonitoringUtil.cloneSourceInString(normalizedMessage.getContent());
                normalizedMessage2.setContent((String)object);
            }
            catch (Exception exception) {
                logger.log(30, (Object)("[Error occured during the normalized message conversion in the monitoring module]: " + exception.getMessage()));
            }
        }
        if ((object = normalizedMessage.getPropertyNames()) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Property property = new Property();
                property.setName(string);
                property.setValue(normalizedMessage.getProperty(string).toString());
                normalizedMessage2.getProperties().add(property);
            }
        }
        return normalizedMessage2;
    }

    public static String marshalError(Exception exception) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        stringWriter.flush();
        String string = stringWriter.toString();
        return string;
    }

    public static org.ow2.petals.tools.monitoring.to.ServiceEndpoint convert(ServiceEndpoint serviceEndpoint) {
        org.ow2.petals.tools.monitoring.to.ServiceEndpoint serviceEndpoint2 = new org.ow2.petals.tools.monitoring.to.ServiceEndpoint();
        if (serviceEndpoint != null) {
            serviceEndpoint2.setEndpointName(serviceEndpoint.getEndpointName());
            ArrayList<String> arrayList = new ArrayList<String>();
            QName[] qNameArray = serviceEndpoint.getInterfaces();
            int n = qNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                QName qName = qNameArray[n2];
                arrayList.add(qName.toString());
                ++n2;
            }
            serviceEndpoint2.setInterfaces(arrayList.toArray(new String[arrayList.size()]));
            serviceEndpoint2.setServiceName(serviceEndpoint.getServiceName().toString());
            serviceEndpoint2.setSubdomainLocation(serviceEndpoint.getLocation().getSubdomainName());
            serviceEndpoint2.setContainerLocation(serviceEndpoint.getLocation().getContainerName());
            serviceEndpoint2.setComponentLocation(serviceEndpoint.getLocation().getComponentName());
        }
        return serviceEndpoint2;
    }
}

