/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitor.ws;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.tools.monitoring.to.ContainerInformations;
import org.ow2.petals.tools.monitoring.to.MessageExchange;
import org.ow2.petals.tools.monitoring.to.RuntimeInformations;
import org.ow2.petals.tools.monitoring.wsapi.MonitoringException;
import org.ow2.petals.tools.monitoring.wsapi.MonitoringService;
import org.ow2.petals.tools.ws.KernelWebService;
import org.petalslink.dsb.kernel.monitor.router.MonitoringModuleImpl;
import org.petalslink.dsb.kernel.monitor.router.MonitoringStorageService;
import org.petalslink.dsb.kernel.monitor.util.MonitoringUtil;
import org.petalslink.dsb.kernel.monitor.util.TOConverter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="webservice", signature=MonitoringService.class), @Interface(name="service", signature=KernelWebService.class)})
public class DistributedMonitoringServiceImpl
implements BindingController,
MonitoringService,
KernelWebService {
    private Component component;
    @Requires(name="topologyService", signature=TopologyService.class)
    private TopologyService topologyService;
    @Requires(name="storageService", signature=MonitoringStorageService.class)
    private MonitoringStorageService storageService;
    @Requires(name="registryService", signature=EndpointRegistry.class)
    private EndpointRegistry registryService;

    public ContainerInformations getContainerInformations(String string) throws MonitoringException {
        try {
            return this.createContainerInformations(string);
        }
        catch (PetalsException petalsException) {
            throw new MonitoringException((Throwable)petalsException);
        }
    }

    public List<org.ow2.petals.tools.monitoring.to.ServiceEndpoint> getEndpoints(String string) throws MonitoringException {
        ArrayList<org.ow2.petals.tools.monitoring.to.ServiceEndpoint> arrayList = new ArrayList<org.ow2.petals.tools.monitoring.to.ServiceEndpoint>();
        List list = null;
        try {
            list = this.registryService.getEndpoints();
        }
        catch (RegistryException registryException) {
            throw new MonitoringException((Throwable)registryException);
        }
        if (list != null) {
            for (ServiceEndpoint serviceEndpoint : list) {
                org.ow2.petals.tools.monitoring.to.ServiceEndpoint serviceEndpoint2 = TOConverter.convert(serviceEndpoint);
                if (!serviceEndpoint2.getContainerLocation().equals(string) && string != null) continue;
                arrayList.add(serviceEndpoint2);
            }
        }
        return arrayList;
    }

    public List<MessageExchange> getMessageExchanges(Date date, Date date2) {
        ArrayList<MessageExchange> arrayList;
        block7: {
            arrayList = new ArrayList<MessageExchange>();
            MonitoringModuleImpl.ExchangeContext[] exchangeContextArray = this.storageService.getStorage().toArray(new MonitoringModuleImpl.ExchangeContext[this.storageService.getStorage().size()]);
            if (exchangeContextArray == null || exchangeContextArray.length <= 0) break block7;
            if (date == null && date2 == null) {
                MonitoringModuleImpl.ExchangeContext[] exchangeContextArray2 = exchangeContextArray;
                int n = exchangeContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MonitoringModuleImpl.ExchangeContext exchangeContext = exchangeContextArray2[n2];
                    arrayList.add(exchangeContext.getExchange());
                    ++n2;
                }
            } else {
                if (date == null) {
                    throw new IllegalArgumentException("The 'begin' parameter must not be null if 'ending' parameter is null too ");
                }
                if (date2 == null) {
                    throw new IllegalArgumentException("The 'ending' parameter must not be null if 'begin' parameter is null too ");
                }
                MonitoringModuleImpl.ExchangeContext[] exchangeContextArray3 = exchangeContextArray;
                int n = exchangeContextArray.length;
                int n3 = 0;
                while (n3 < n) {
                    MonitoringModuleImpl.ExchangeContext exchangeContext = exchangeContextArray3[n3];
                    if (exchangeContext.getTimestamp().after(date) && exchangeContext.getTimestamp().before(date2)) {
                        arrayList.add(exchangeContext.getExchange());
                    }
                    ++n3;
                }
            }
        }
        return arrayList;
    }

    public RuntimeInformations getRuntimeInformations() {
        return this.createRuntimeInformations();
    }

    public List<String> getServices() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MonitoringModuleImpl.ExchangeContext[] exchangeContextArray = this.storageService.getStorage().toArray(new MonitoringModuleImpl.ExchangeContext[this.storageService.getStorage().size()]);
        if (exchangeContextArray != null && exchangeContextArray.length > 0) {
            MonitoringModuleImpl.ExchangeContext[] exchangeContextArray2 = exchangeContextArray;
            int n = exchangeContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                MonitoringModuleImpl.ExchangeContext exchangeContext = exchangeContextArray2[n2];
                if (!arrayList.contains(exchangeContext.getExchange().getService().toString())) {
                    arrayList.add(exchangeContext.getExchange().getService().toString());
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public String resolveContainerForEndpoint(String string) throws MonitoringException {
        List list = null;
        try {
            list = this.registryService.getEndpoints();
        }
        catch (RegistryException registryException) {
            throw new MonitoringException((Throwable)registryException);
        }
        if (list != null) {
            for (ServiceEndpoint serviceEndpoint : list) {
                if (!serviceEndpoint.getEndpointName().equals(string)) continue;
                return serviceEndpoint.getLocation().getContainerName();
            }
        }
        return null;
    }

    private ContainerInformations createContainerInformations(String string) throws PetalsException {
        ContainerInformations containerInformations = new ContainerInformations();
        ContainerConfiguration containerConfiguration = this.topologyService.getContainerConfiguration(string);
        containerInformations.setWebservicePort(containerConfiguration.getWebservicePort());
        containerInformations.setWebservicePrefix(containerConfiguration.getWebservicePrefix());
        containerInformations.setContainerId(string);
        containerInformations.setDaemonThreadCount((long)ManagementFactory.getThreadMXBean().getDaemonThreadCount());
        containerInformations.setDescription(containerConfiguration.getDescription());
        containerInformations.setHeapMemoryUsage(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
        containerInformations.setHost(containerConfiguration.getHost());
        containerInformations.setHttpPort("3333");
        containerInformations.setJmxJNDIPort(Integer.toString(containerConfiguration.getJmxRMIConnectorPort()));
        containerInformations.setObjectPendingFinalizationCount((long)ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount());
        containerInformations.setPeakThreadCount((long)ManagementFactory.getThreadMXBean().getPeakThreadCount());
        containerInformations.setSslPort("3333");
        containerInformations.setStatus(containerConfiguration.getState().toString());
        containerInformations.setTcpPort(Integer.toString(containerConfiguration.getTCPPort()));
        containerInformations.setThreadCount((long)ManagementFactory.getThreadMXBean().getThreadCount());
        containerInformations.setTotalStartedThreadCount(ManagementFactory.getThreadMXBean().getTotalStartedThreadCount());
        containerInformations.setUpTime(ManagementFactory.getRuntimeMXBean().getUptime());
        containerInformations.setVersion(containerConfiguration.getDescription());
        return containerInformations;
    }

    private RuntimeInformations createRuntimeInformations() {
        RuntimeInformations runtimeInformations = new RuntimeInformations();
        runtimeInformations.setAvailableProcessors((long)ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors());
        runtimeInformations.setClassLoading(DistributedMonitoringServiceImpl.class.getClassLoader().getClass().getName());
        runtimeInformations.setFreeMemory(Runtime.getRuntime().freeMemory());
        runtimeInformations.setMaxMemory(Runtime.getRuntime().maxMemory());
        runtimeInformations.setMemory(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().toString());
        runtimeInformations.setOperationSystem(ManagementFactory.getOperatingSystemMXBean().getName());
        runtimeInformations.setProcessCPUTime(ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime());
        runtimeInformations.setRuntime(ManagementFactory.getRuntimeMXBean().getName());
        runtimeInformations.setThreading(Boolean.toString(ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported()));
        runtimeInformations.setTotalMemory(Runtime.getRuntime().totalMemory());
        return runtimeInformations;
    }

    public Component getComponent() {
        return this.component;
    }

    public List<String> getAllContainerName() throws MonitoringException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = null;
        set = this.topologyService.getContainersConfiguration(null);
        if (set != null) {
            for (ContainerConfiguration containerConfiguration : set) {
                arrayList.add(containerConfiguration.getName());
            }
        }
        return arrayList;
    }

    public List<ContainerInformations> getContainersInformations() throws MonitoringException {
        ArrayList<ContainerInformations> arrayList = new ArrayList<ContainerInformations>();
        Set set = null;
        set = this.topologyService.getContainersConfiguration(null);
        if (set != null) {
            for (ContainerConfiguration containerConfiguration : set) {
                ContainerInformations containerInformations = new ContainerInformations();
                containerInformations.setContainerId(containerConfiguration.getName());
                containerInformations.setDaemonThreadCount((long)ManagementFactory.getThreadMXBean().getDaemonThreadCount());
                containerInformations.setDescription(containerConfiguration.getDescription());
                containerInformations.setHeapMemoryUsage(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
                containerInformations.setHost(containerConfiguration.getHost());
                containerInformations.setHttpPort("3333");
                containerInformations.setJmxJNDIPort(Integer.toString(containerConfiguration.getJmxRMIConnectorPort()));
                containerInformations.setObjectPendingFinalizationCount((long)ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount());
                containerInformations.setPeakThreadCount((long)ManagementFactory.getThreadMXBean().getPeakThreadCount());
                containerInformations.setSslPort("3333");
                containerInformations.setStatus(containerConfiguration.getState().toString());
                containerInformations.setTcpPort(Integer.toString(containerConfiguration.getTCPPort()));
                containerInformations.setThreadCount((long)ManagementFactory.getThreadMXBean().getThreadCount());
                containerInformations.setTotalStartedThreadCount(ManagementFactory.getThreadMXBean().getTotalStartedThreadCount());
                containerInformations.setUpTime(ManagementFactory.getRuntimeMXBean().getUptime());
                containerInformations.setVersion(containerConfiguration.getDescription());
                arrayList.add(containerInformations);
            }
        }
        return arrayList;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("topologyService")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        if (string.equals("storageService")) {
            if (!MonitoringStorageService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + MonitoringStorageService.class.getName());
            }
            this.storageService = (MonitoringStorageService)object;
            return;
        }
        if (string.equals("registryService")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.registryService = (EndpointRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String getDescriptionEndpoint(String string) throws MonitoringException {
        List list = null;
        try {
            list = this.registryService.getEndpoints();
        }
        catch (RegistryException registryException) {
            throw new MonitoringException((Throwable)registryException);
        }
        if (list != null) {
            for (ServiceEndpoint serviceEndpoint : list) {
                if (!serviceEndpoint.getEndpointName().equals(string)) continue;
                Document document = null;
                try {
                    document = this.registryService.getEndpointDescriptorForEndpoint(serviceEndpoint);
                }
                catch (RegistryException registryException) {
                    throw new MonitoringException((Throwable)registryException);
                }
                if (document == null) continue;
                try {
                    return MonitoringUtil.parseToString(document.cloneNode(true));
                }
                catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                    throw new MonitoringException((Throwable)transformerFactoryConfigurationError);
                }
                catch (TransformerException transformerException) {
                    throw new MonitoringException((Throwable)transformerException);
                }
            }
        }
        return null;
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("topologyService");
        arrayList.add("storageService");
        arrayList.add("registryService");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("topologyService")) {
            return this.topologyService;
        }
        if (string.equals("storageService")) {
            return this.storageService;
        }
        if (string.equals("registryService")) {
            return this.registryService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("topologyService")) {
            this.topologyService = null;
            return;
        }
        if (string.equals("storageService")) {
            this.storageService = null;
            return;
        }
        if (string.equals("registryService")) {
            this.registryService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

