/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.workqueue;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.workqueue.AutomaticWorkQueue;

@NoJSR250Annotations
public class AutomaticWorkQueueImpl
implements AutomaticWorkQueue {
    static final int DEFAULT_MAX_QUEUE_SIZE = 256;
    private static final Logger LOG = LogUtils.getL7dLogger(AutomaticWorkQueueImpl.class);
    String name = "default";
    int maxQueueSize;
    int initialThreads;
    int lowWaterMark;
    int highWaterMark;
    long dequeueTimeout;
    ThreadPoolExecutor executor;
    AWQThreadFactory threadFactory;
    ReentrantLock mainLock;
    DelayQueue<DelayedTaskWrapper> delayQueue;
    WatchDog watchDog;
    boolean shared;
    int sharedCount;

    public AutomaticWorkQueueImpl() {
        this(256);
    }

    public AutomaticWorkQueueImpl(String name) {
        this(256, name);
    }

    public AutomaticWorkQueueImpl(int max) {
        this(max, "default");
    }

    public AutomaticWorkQueueImpl(int max, String name) {
        this(max, 0, 25, 5, 120000L, name);
    }

    public AutomaticWorkQueueImpl(int mqs, int initialThreads, int highWaterMark, int lowWaterMark, long dequeueTimeout) {
        this(mqs, initialThreads, highWaterMark, lowWaterMark, dequeueTimeout, "default");
    }

    public AutomaticWorkQueueImpl(int mqs, int initialThreads, int highWaterMark, int lowWaterMark, long dequeueTimeout, String name) {
        this.maxQueueSize = mqs == -1 ? 256 : mqs;
        this.initialThreads = initialThreads;
        this.highWaterMark = -1 == highWaterMark ? Integer.MAX_VALUE : highWaterMark;
        this.lowWaterMark = -1 == lowWaterMark ? Integer.MAX_VALUE : lowWaterMark;
        this.dequeueTimeout = dequeueTimeout;
        this.name = name;
    }

    public void setShared(boolean b) {
        this.shared = b;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void addSharedUser() {
        ++this.sharedCount;
    }

    public void removeSharedUser() {
        --this.sharedCount;
    }

    public int getShareCount() {
        return this.sharedCount;
    }

    protected synchronized ThreadPoolExecutor getExecutor() {
        if (this.executor == null) {
            this.threadFactory = AutomaticWorkQueueImpl.createThreadFactory(this.name);
            this.executor = new ThreadPoolExecutor(this.lowWaterMark, this.highWaterMark, TimeUnit.MILLISECONDS.toMillis(this.dequeueTimeout), TimeUnit.MILLISECONDS, new LinkedBlockingQueue(this.maxQueueSize), this.threadFactory){

                protected void terminated() {
                    ThreadFactory f = AutomaticWorkQueueImpl.this.executor.getThreadFactory();
                    if (f instanceof AWQThreadFactory) {
                        ((AWQThreadFactory)f).shutdown();
                    }
                    if (AutomaticWorkQueueImpl.this.watchDog != null) {
                        AutomaticWorkQueueImpl.this.watchDog.shutdown();
                    }
                }
            };
            StringBuilder buf = new StringBuilder();
            buf.append("Constructing automatic work queue with:\n");
            buf.append("max queue size: " + this.maxQueueSize + "\n");
            buf.append("initialThreads: " + this.initialThreads + "\n");
            buf.append("lowWaterMark: " + this.lowWaterMark + "\n");
            buf.append("highWaterMark: " + this.highWaterMark + "\n");
            LOG.fine(buf.toString());
            if (this.initialThreads > this.highWaterMark) {
                this.initialThreads = this.highWaterMark;
            }
            if (this.initialThreads < Integer.MAX_VALUE && this.initialThreads > 0) {
                this.executor.setCorePoolSize(this.initialThreads);
                int started = this.executor.prestartAllCoreThreads();
                if (started < this.initialThreads) {
                    LOG.log(Level.WARNING, "THREAD_START_FAILURE_MSG", new Object[]{started, this.initialThreads});
                }
                this.executor.setCorePoolSize(this.lowWaterMark);
            }
            ReentrantLock l = null;
            try {
                Field f = ThreadPoolExecutor.class.getDeclaredField("mainLock");
                ReflectionUtil.setAccessible((AccessibleObject)f);
                l = (ReentrantLock)f.get(this.executor);
            }
            catch (Throwable t) {
                l = new ReentrantLock();
            }
            this.mainLock = l;
        }
        return this.executor;
    }

    private static AWQThreadFactory createThreadFactory(final String name) {
        ThreadGroup group;
        try {
            group = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup group;
                    try {
                        for (ThreadGroup parent = group = Thread.currentThread().getThreadGroup(); parent != null; parent = parent.getParent()) {
                            group = parent;
                        }
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return new ThreadGroup(group, name + "-workqueue");
                }
            });
        }
        catch (SecurityException e) {
            group = new ThreadGroup(name + "-workqueue");
        }
        return new AWQThreadFactory(group, name);
    }

    public void setName(String s) {
        this.name = s;
        if (this.threadFactory != null) {
            this.threadFactory.setName(s);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append(" [queue size: ");
        buf.append(this.getSize());
        buf.append(", max size: ");
        buf.append(this.maxQueueSize);
        buf.append(", threads: ");
        buf.append(this.getPoolSize());
        buf.append(", active threads: ");
        buf.append(this.getActiveCount());
        buf.append(", low water mark: ");
        buf.append(this.getLowWaterMark());
        buf.append(", high water mark: ");
        buf.append(this.getHighWaterMark());
        buf.append("]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Runnable command) {
        final ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ClassLoaderUtils.ClassLoaderHolder orig = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
                try {
                    command.run();
                }
                finally {
                    if (orig != null) {
                        orig.reset();
                    }
                }
            }
        };
        ThreadPoolExecutor ex = this.getExecutor();
        ex.execute(r);
        if (!ex.getQueue().isEmpty() && this.getPoolSize() < this.highWaterMark) {
            this.mainLock.lock();
            try {
                int ps = this.getPoolSize();
                int sz = this.executor.getQueue().size();
                int sz2 = this.getActiveCount();
                if (sz + sz2 > ps) {
                    Method m = ThreadPoolExecutor.class.getDeclaredMethod("addIfUnderMaximumPoolSize", Runnable.class);
                    ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke((Object)this.executor, new Object[1]);
                }
            }
            catch (Exception exc) {
            }
            finally {
                this.mainLock.unlock();
            }
        }
    }

    public void execute(Runnable work, long timeout) {
        try {
            this.execute(work);
        }
        catch (RejectedExecutionException ree) {
            try {
                this.getExecutor().getQueue().offer(work, timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                throw new RejectedExecutionException(ie);
            }
        }
    }

    public synchronized void schedule(Runnable work, long delay) {
        if (this.delayQueue == null) {
            this.delayQueue = new DelayQueue();
            this.watchDog = new WatchDog(this.delayQueue);
            this.watchDog.setDaemon(true);
            this.watchDog.start();
        }
        this.delayQueue.put(new DelayedTaskWrapper(work, delay));
    }

    public void shutdown(boolean processRemainingWorkItems) {
        if (this.executor != null) {
            if (!processRemainingWorkItems) {
                this.executor.getQueue().clear();
            }
            this.executor.shutdown();
        }
    }

    public long getMaxSize() {
        return this.maxQueueSize;
    }

    public long getSize() {
        return this.executor == null ? 0L : (long)this.executor.getQueue().size();
    }

    public boolean isEmpty() {
        return this.executor == null ? true : this.executor.getQueue().size() == 0;
    }

    boolean isFull() {
        return this.executor == null ? false : this.executor.getQueue().remainingCapacity() == 0;
    }

    public int getHighWaterMark() {
        int hwm = this.executor == null ? this.highWaterMark : this.executor.getMaximumPoolSize();
        return hwm == Integer.MAX_VALUE ? -1 : hwm;
    }

    public int getLowWaterMark() {
        int lwm = this.executor == null ? this.lowWaterMark : this.executor.getCorePoolSize();
        return lwm == Integer.MAX_VALUE ? -1 : lwm;
    }

    public void setHighWaterMark(int hwm) {
        int n = this.highWaterMark = hwm < 0 ? Integer.MAX_VALUE : hwm;
        if (this.executor != null) {
            this.executor.setMaximumPoolSize(this.highWaterMark);
        }
    }

    public void setLowWaterMark(int lwm) {
        int n = this.lowWaterMark = lwm < 0 ? 0 : lwm;
        if (this.executor != null) {
            this.executor.setCorePoolSize(this.lowWaterMark);
        }
    }

    public void setInitialSize(int initialSize) {
        this.initialThreads = initialSize;
    }

    public void setQueueSize(int size) {
        this.maxQueueSize = size;
    }

    public void setDequeueTimeout(long l) {
        this.dequeueTimeout = l;
    }

    public boolean isShutdown() {
        if (this.executor == null) {
            return false;
        }
        return this.executor.isShutdown();
    }

    public int getLargestPoolSize() {
        if (this.executor == null) {
            return 0;
        }
        return this.executor.getLargestPoolSize();
    }

    public int getPoolSize() {
        if (this.executor == null) {
            return 0;
        }
        return this.executor.getPoolSize();
    }

    public int getActiveCount() {
        if (this.executor == null) {
            return 0;
        }
        return this.executor.getActiveCount();
    }

    static class AWQThreadFactory
    implements ThreadFactory {
        final AtomicInteger threadNumber = new AtomicInteger(1);
        ThreadGroup group;
        String name;
        ClassLoader loader;

        AWQThreadFactory(ThreadGroup gp, String nm) {
            this.group = gp;
            this.name = nm;
            this.loader = AutomaticWorkQueueImpl.class.getClassLoader();
        }

        public Thread newThread(Runnable r) {
            if (this.group.isDestroyed()) {
                this.group = new ThreadGroup(this.group.getParent(), this.name + "-workqueue");
            }
            final Thread t = new Thread(this.group, r, this.name + "-workqueue-" + this.threadNumber.getAndIncrement(), 0L);
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    t.setContextClassLoader(AWQThreadFactory.this.loader);
                    return true;
                }
            });
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }

        public void setName(String s) {
            this.name = s;
        }

        public void shutdown() {
            if (!this.group.isDestroyed()) {
                try {
                    this.group.destroy();
                    this.group.setDaemon(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WatchDog
    extends Thread {
        DelayQueue<DelayedTaskWrapper> delayQueue;
        AtomicBoolean shutdown = new AtomicBoolean(false);

        WatchDog(DelayQueue<DelayedTaskWrapper> queue) {
            this.delayQueue = queue;
        }

        public void shutdown() {
            this.shutdown.set(true);
            this.interrupt();
        }

        @Override
        public void run() {
            block5: {
                try {
                    while (!this.shutdown.get()) {
                        DelayedTaskWrapper task = (DelayedTaskWrapper)this.delayQueue.take();
                        if (task == null) continue;
                        try {
                            AutomaticWorkQueueImpl.this.execute(task);
                        }
                        catch (Exception ex) {
                            LOG.warning("Executing the task from DelayQueue with exception: " + ex);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.finer("The DelayQueue watchdog Task is stopping");
                }
            }
        }
    }

    static class DelayedTaskWrapper
    implements Delayed,
    Runnable {
        long trigger;
        Runnable work;

        DelayedTaskWrapper(Runnable work, long delay) {
            this.work = work;
            this.trigger = System.currentTimeMillis() + delay;
        }

        public long getDelay(TimeUnit unit) {
            long n = this.trigger - System.currentTimeMillis();
            return unit.convert(n, TimeUnit.MILLISECONDS);
        }

        public int compareTo(Delayed delayed) {
            long other = ((DelayedTaskWrapper)delayed).trigger;
            int returnValue = this.trigger < other ? -1 : (this.trigger > other ? 1 : 0);
            return returnValue;
        }

        public void run() {
            this.work.run();
        }
    }
}

