/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.util;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class LoggingUtil
implements org.ow2.petals.kernel.api.log.Logger {
    protected Logger log;
    protected String name;

    public LoggingUtil(Logger logger) {
        this(logger, "");
    }

    public LoggingUtil(Logger logger, String loggerName) {
        this.log = logger;
        loggerName = loggerName != null && loggerName.trim().length() > 0 ? "[" + loggerName + "] " : "";
        this.name = loggerName;
    }

    public void call() {
        if (this.log != null && this.log.isLoggable(BasicLevel.DEBUG)) {
            this.log.log(BasicLevel.LEVEL_DEBUG, (Object)(this.name + "-CALL-" + LoggingUtil.classAndMethod()));
        }
    }

    public void call(Object msg) {
        if (this.log != null && this.log.isLoggable(BasicLevel.DEBUG)) {
            this.log.log(BasicLevel.LEVEL_DEBUG, (Object)(this.name + "-CALL-" + LoggingUtil.classAndMethod() + " " + msg));
        }
    }

    public void start() {
        if (this.log != null && this.log.isLoggable(BasicLevel.DEBUG)) {
            this.log.log(BasicLevel.LEVEL_DEBUG, (Object)(this.name + "-START-" + LoggingUtil.classAndMethod()));
        }
    }

    public void start(Object msg) {
        if (this.log != null && this.log.isLoggable(BasicLevel.DEBUG)) {
            this.log.log(BasicLevel.LEVEL_DEBUG, (Object)(this.name + "-START-" + LoggingUtil.classAndMethod() + " " + msg));
        }
    }

    public void end() {
        if (this.log != null && this.log.isLoggable(BasicLevel.DEBUG)) {
            this.log.log(BasicLevel.LEVEL_DEBUG, (Object)(this.name + "-END-" + LoggingUtil.classAndMethod()));
        }
    }

    public void end(Object msg) {
        if (this.log != null && this.log.isLoggable(BasicLevel.DEBUG)) {
            this.log.log(BasicLevel.LEVEL_DEBUG, (Object)(this.name + "-END-" + LoggingUtil.classAndMethod() + " " + msg));
        }
    }

    public void debug(Object message) {
        if (this.log != null && this.log.isLoggable(BasicLevel.DEBUG)) {
            this.log.log(BasicLevel.LEVEL_DEBUG, (Object)(this.name + LoggingUtil.classAndMethod() + " " + message));
        }
    }

    public void info(Object message) {
        if (this.log != null && this.log.isLoggable(BasicLevel.INFO)) {
            if (this.log.isLoggable(BasicLevel.DEBUG)) {
                this.log.log(BasicLevel.LEVEL_INFO, (Object)(this.name + LoggingUtil.classAndMethod() + " " + message));
            } else {
                this.log.log(BasicLevel.LEVEL_INFO, (Object)(this.name + message));
            }
        }
    }

    public void info(Object message, Throwable error) {
        if (this.log != null && this.log.isLoggable(BasicLevel.INFO)) {
            if (this.log.isLoggable(BasicLevel.DEBUG)) {
                this.log.log(BasicLevel.LEVEL_INFO, (Object)(this.name + LoggingUtil.classAndMethod() + " " + message), error);
            } else {
                this.log.log(BasicLevel.LEVEL_INFO, (Object)(this.name + message), error);
            }
        }
    }

    public void warning(Object message) {
        if (this.log != null && this.log.isLoggable(BasicLevel.WARN)) {
            this.log.log(BasicLevel.LEVEL_WARN, (Object)(this.name + message));
        }
    }

    public void warning(Object message, Throwable throwable) {
        if (this.log != null && this.log.isLoggable(BasicLevel.WARN)) {
            this.log.log(BasicLevel.LEVEL_WARN, (Object)(this.name + message), throwable);
        }
    }

    public void error(Object message) {
        if (this.log != null && this.log.isLoggable(BasicLevel.ERROR)) {
            this.log.log(BasicLevel.LEVEL_ERROR, (Object)(this.name + message));
        }
    }

    public void error(Object message, Throwable throwable) {
        if (this.log != null && this.log.isLoggable(BasicLevel.ERROR)) {
            this.log.log(BasicLevel.LEVEL_ERROR, (Object)(this.name + message), throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(BasicLevel.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(BasicLevel.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(BasicLevel.WARN);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(BasicLevel.ERROR);
    }

    private boolean isLevelEnabled(int level) {
        return this.log != null && this.log.isLoggable(level);
    }

    private static String classAndMethod() {
        String result = null;
        Throwable t = new Throwable();
        StackTraceElement[] ste = t.getStackTrace();
        if (ste != null && ste.length > 2) {
            String className;
            int index;
            StackTraceElement element = ste[2];
            if (element.getClassName().endsWith(LoggingUtil.class.getName())) {
                element = ste[3];
            }
            if ((index = (className = element.getClassName()).lastIndexOf(".")) > -1) {
                className = className.substring(index + 1, className.length());
            }
            result = className + "." + element.getMethodName() + "()";
        }
        return result;
    }

    public String getName() {
        return this.log.getName();
    }
}

