/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.easierbsm.connector;

import easyesb.petalslink.com.service.wsdmadmin._1_0.AdminExceptionMsg;
import easyesb.petalslink.com.service.wsdmadmin._1_0.WSDMAdminItf;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.cxf.CXFHelper;
import org.petalslink.dsb.monitoring.api.MonitoringAdminClient;

public class EasierBSMAdminClient
implements MonitoringAdminClient {
    private String address;
    private WSDMAdminItf wsdmAdmin;
    private static Logger logger = Logger.getLogger(EasierBSMAdminClient.class.getName());

    public EasierBSMAdminClient(String address) {
        this.address = address;
    }

    public void createMonitoringEndpoint(ServiceEndpoint serviceEndpoint) throws DSBException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Creating monitoring endpoint for service " + serviceEndpoint);
        }
        if (serviceEndpoint == null) {
            String message = "Can not create monitoring endpoint from null endpoint...";
            throw new DSBException("Can not create monitoring endpoint from null endpoint...");
        }
        WSDMAdminItf wsdmAdminItf = this.getAdminClient();
        String wsdmProviderEndpointName = serviceEndpoint.getEndpointName() + "_WSDMMonitoring";
        String result = null;
        try {
            result = wsdmAdminItf.createMonitoringEndpoint(serviceEndpoint.getServiceName(), wsdmProviderEndpointName, true);
        }
        catch (AdminExceptionMsg e) {
            String message = "Error while sending request to monitoring layer";
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.WARNING, "Error while sending request to monitoring layer", e);
            }
            throw new DSBException("Error while sending request to monitoring layer", (Throwable)e);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Monitoring bus returned " + result);
        }
    }

    private synchronized WSDMAdminItf getAdminClient() {
        if (this.wsdmAdmin == null) {
            this.wsdmAdmin = (WSDMAdminItf)CXFHelper.getClientFromFinalURL((String)this.address, WSDMAdminItf.class);
        }
        return this.wsdmAdmin;
    }

    public void deleteMonitoringEndpoint(ServiceEndpoint serviceEndpoint) throws DSBException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Deleting monitoring endpoint for service " + serviceEndpoint);
        }
        if (serviceEndpoint == null) {
            String message = "Can not delete monitoring endpoint from null endpoint...";
            throw new DSBException("Can not delete monitoring endpoint from null endpoint...");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Deleting monitoring endpoint for easierBSM is not implemented");
        }
    }
}

