/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.client;

import java.util.ArrayList;
import java.util.List;
import org.ow2.petals.registry.api.Endpoint;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.factory.ResourceFactory;
import org.ow2.petals.registry.api.util.ResourceUtil;
import org.ow2.petals.registry.client.api.RegistryClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegistryClientImpl
implements RegistryClient {
    private final LocalRegistry localRegistry;

    public RegistryClientImpl(LocalRegistry localRegistry) {
        this.localRegistry = localRegistry;
    }

    @Override
    public void delete(String path, boolean b) throws RegistryException {
        if (path == null) {
            throw new RegistryException("Path is null");
        }
        this.localRegistry.delete(path, b);
    }

    @Override
    public Endpoint get(String path, boolean b) throws RegistryException {
        if (path == null || ResourceUtil.isDirectory(path)) {
            throw new RegistryException("Bad path (null or directory)");
        }
        Endpoint result = null;
        Resource r = this.localRegistry.get(path, b);
        if (r != null) {
            result = r.getEndpoint();
        }
        return result;
    }

    @Override
    public boolean put(String path, Endpoint endpoint, boolean b) throws RegistryException {
        if (path == null || ResourceUtil.isDirectory(path)) {
            throw new RegistryException("Bad path (null or directory)");
        }
        Resource r = ResourceFactory.createResource(endpoint);
        return this.localRegistry.put(path, r, b);
    }

    @Override
    public List<Endpoint> getAll(String path, boolean b) throws RegistryException {
        if (path == null || !ResourceUtil.isDirectory(path)) {
            throw new RegistryException("Bad path (null or not directory)");
        }
        ArrayList<Endpoint> result = new ArrayList<Endpoint>();
        List<Resource> resources = this.localRegistry.getAll(path, b);
        if (resources != null) {
            result = new ArrayList(resources.size());
            for (Resource resource : resources) {
                Endpoint ep = resource.getEndpoint();
                if (ep == null) continue;
                result.add(ep);
            }
        }
        return result;
    }

    @Override
    public List<Endpoint> lookup(Query query, boolean b) throws RegistryException {
        if (query == null) {
            throw new RegistryException("Query can not be null");
        }
        ArrayList<Endpoint> result = new ArrayList<Endpoint>();
        List<Resource> r = this.localRegistry.query(query, b);
        if (r != null) {
            for (Resource resource : r) {
                Endpoint ep = resource.getEndpoint();
                if (ep == null) continue;
                result.add(ep);
            }
        }
        return result;
    }

    public LocalRegistry getLocalRegistry() {
        return this.localRegistry;
    }
}

