/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.notification.commons;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.WstConstants;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.petalslink.dsb.notification.commons.NotificationException;
import org.petalslink.dsb.notification.commons.SOAUtil;
import org.petalslink.dsb.notification.commons.api.NotificationManager;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationManagerImpl
implements NotificationManager {
    public static final String EBM_RESOURCEIDS_PREFIX = "ebm";
    public static final String EBM_RESOURCEIDS_NAMESPACE_URI = "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds";
    private static final String EBM_TOPICS_EXTENSION_NAMESPACE_URI = "http://org.ow2.petals/ebmwebsourcing/specific/topicExtension";
    public static final QName SUPPORTED_QNAME_ATTR = new QName("http://org.ow2.petals/ebmwebsourcing/specific/topicExtension", "supported", "ebm");
    private static Logger logger = Logger.getLogger(NotificationManagerImpl.class.getName());
    private TopicNamespaceType topicNamespace;
    private TopicSetType topicSet;
    private TopicsManagerEngine topicsManagerEngine;
    private SubscriptionManagerEngine subscriptionManagerEngine;
    private NotificationProducerEngine notificationProducerEngine;
    private QName serviceName;
    private QName interfaceName;
    private String endpointName;
    private List<String> supportedTopics;

    public NotificationManagerImpl(URL topicSetXML, URL topicNamespaceRPUpdate, QName serviceName, QName interfaceName, String endpointName) {
        this.endpointName = endpointName;
        this.serviceName = serviceName;
        this.interfaceName = interfaceName;
        org.w3c.dom.Document topicSetDom = null;
        org.w3c.dom.Document topicNSRPUpdateDom = null;
        try {
            topicSetDom = SOAUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(topicSetXML.openStream());
            topicNSRPUpdateDom = SOAUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(topicNamespaceRPUpdate.openStream());
            this.topicSet = RefinedWstopFactory.getInstance().getWstopReader().readTopicSetType(topicSetDom);
            this.topicNamespace = RefinedWstopFactory.getInstance().getWstopReader().readTopicNamespaceType(topicNSRPUpdateDom);
            org.w3c.dom.Document out = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicSetTypeAsDOM(this.topicSet);
            org.w3c.dom.Document out2 = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicNamespaceTypeAsDOM(this.topicNamespace);
            System.out.println("TOPIC SET : " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)out));
            System.out.println("TOPIC NS RP Update : " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)out2));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (WstopException e) {
            e.printStackTrace();
        }
        this.topicsManagerEngine = new TopicsManagerEngine();
        this.subscriptionManagerEngine = new SubscriptionManagerEngine(logger);
        this.subscriptionManagerEngine.setSubscriptionsManagerEdp(this.getEndpointName());
        this.subscriptionManagerEngine.setSubscriptionsManagerInterface(this.getInterfaceName());
        this.subscriptionManagerEngine.setSubscriptionsManagerService(this.getServiceName());
        try {
            this.notificationProducerEngine = new NotificationProducerEngine(logger, this.getTopicsManagerEngine(), this.getSubscriptionManagerEngine(), true, this.getTopicSet(), this.getTopicNamespace(), "wsn", null);
        }
        catch (WsnbException e) {
            e.printStackTrace();
        }
    }

    public NotificationManagerImpl(URL topicNamespaces, List<String> supportedTopics, QName serviceName, QName interfaceName, String endpointName) {
        this.endpointName = endpointName;
        this.serviceName = serviceName;
        this.interfaceName = interfaceName;
        org.w3c.dom.Document docTopicNs = null;
        try {
            docTopicNs = SOAUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(topicNamespaces.openStream());
            this.supportedTopics = supportedTopics;
            this.topicNamespace = RefinedWstopFactory.getInstance().getWstopReader().readTopicNamespaceType(docTopicNs);
            this.topicSet = this.createTopicSetFromTopicNamespace(this.topicNamespace, supportedTopics);
            org.w3c.dom.Document topicSetDom = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicSetTypeAsDOM(this.topicSet);
            System.out.println("topicSetDom = " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)topicSetDom));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (WstopException e) {
            e.printStackTrace();
        }
        catch (NotificationException e) {
            e.printStackTrace();
        }
        this.topicsManagerEngine = new TopicsManagerEngine();
        this.subscriptionManagerEngine = new SubscriptionManagerEngine(logger);
        this.subscriptionManagerEngine.setSubscriptionsManagerEdp(this.getEndpointName());
        this.subscriptionManagerEngine.setSubscriptionsManagerInterface(this.getInterfaceName());
        this.subscriptionManagerEngine.setSubscriptionsManagerService(this.getServiceName());
        try {
            this.notificationProducerEngine = new NotificationProducerEngine(logger, this.getTopicsManagerEngine(), this.getSubscriptionManagerEngine(), true, this.getTopicSet(), this.getTopicNamespace(), "wsn", null);
        }
        catch (WsnbException e) {
            e.printStackTrace();
        }
    }

    private QName getServiceName() {
        return this.serviceName;
    }

    private QName getInterfaceName() {
        return this.interfaceName;
    }

    private String getEndpointName() {
        return this.endpointName;
    }

    public TopicSetType createTopicSetFromTopicNamespace(TopicNamespaceType topicns, List<String> topics) throws NotificationException {
        TopicSetType res = null;
        TopicNamespaceType topicNS = null;
        org.w3c.dom.Document domDocument = null;
        try {
            domDocument = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicNamespaceTypeAsDOM(topicns);
        }
        catch (WstopException e) {
            throw new NotificationException(e);
        }
        DOMBuilder builder = new DOMBuilder();
        Document jdomDocument = builder.build(domDocument);
        this.addSupportedTopicAttr(jdomDocument.getRootElement().getChildren(), topics);
        DOMOutputter converter = new DOMOutputter();
        try {
            domDocument = converter.output(jdomDocument);
        }
        catch (JDOMException e) {
            throw new NotificationException(e);
        }
        try {
            topicNS = RefinedWstopFactory.getInstance().getWstopReader().readTopicNamespaceType(domDocument);
        }
        catch (WstopException e) {
            throw new NotificationException(e);
        }
        res = this.createTopicSetFromSupportedTopicNamespace(topicNS);
        return res;
    }

    public TopicSetType createTopicSetFromSupportedTopicNamespace(TopicNamespaceType topicns) throws NotificationException {
        TopicSetType res = null;
        Namespace tns = Namespace.getNamespace((String)"tns", (String)topicns.getNamespace().toString());
        Element root = this.createEmptyTopicSet();
        Document doc = new Document(root);
        this.createTopicSetTree(topicns.getTopics(), root, tns, true);
        org.w3c.dom.Document domDocument = null;
        DOMOutputter converter = new DOMOutputter();
        try {
            domDocument = converter.output(doc);
        }
        catch (JDOMException e) {
            throw new NotificationException(e);
        }
        try {
            res = RefinedWstopFactory.getInstance().getWstopReader().readTopicSetType(domDocument);
        }
        catch (WstopException e) {
            throw new NotificationException(e);
        }
        return res;
    }

    private Element createEmptyTopicSet() {
        Namespace wstop = Namespace.getNamespace((String)"wstop", (String)"http://docs.oasis-open.org/wsn/t-1");
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element root = new Element(WstConstants.TOPIC_SET_QNAME.getLocalPart(), wstop);
        root.addNamespaceDeclaration(xsi);
        root.setAttribute("schemaLocation", "http://docs.oasis-open.org/wsn/t-1 http://docs.oasis-open.org/wsn/t-1.xsd", xsi);
        return root;
    }

    private void addSupportedTopicAttr(List<Element> children, List<String> topics) {
        for (Element child : children) {
            if (!child.getName().equals(WstopConstants.TOPIC_QNAME.getLocalPart()) || !child.getNamespaceURI().equals(WstopConstants.TOPIC_QNAME.getNamespaceURI())) continue;
            if (topics.contains(child.getAttribute("name").getValue())) {
                child.setAttribute(SUPPORTED_QNAME_ATTR.getLocalPart(), "true", Namespace.getNamespace((String)SUPPORTED_QNAME_ATTR.getPrefix(), (String)SUPPORTED_QNAME_ATTR.getNamespaceURI()));
            }
            if (child.getChildren() == null || child.getChildren().size() <= 0) continue;
            this.addSupportedTopicAttr(child.getChildren(), topics);
        }
    }

    private void createTopicSetTree(List<TopicType> topics, Element root, Namespace tns, boolean first) {
        Namespace wstop = Namespace.getNamespace((String)"wstop", (String)"http://docs.oasis-open.org/wsn/t-1");
        for (TopicType topic : topics) {
            Element childTopic = null;
            childTopic = first ? new Element(topic.getName(), tns) : new Element(topic.getName());
            if (NotificationManagerImpl.isTopicSupported(topic) != null && NotificationManagerImpl.isTopicSupported(topic).booleanValue()) {
                childTopic.setAttribute("topic", "true", wstop);
                root.addContent((Content)childTopic);
            }
            if (topic.getTopics() == null || topic.getTopics().size() <= 0) continue;
            this.createTopicSetTree(topic.getTopics(), childTopic, tns, false);
        }
    }

    public static Boolean isTopicSupported(TopicType topic) {
        Boolean res = null;
        com.ebmwebsourcing.wsstar.jaxb.notification.topics.TopicType model = TopicTypeImpl.toJaxbModel((TopicType)topic);
        String value = (String)model.getOtherAttributes().get(SUPPORTED_QNAME_ATTR);
        if (value != null) {
            res = Boolean.valueOf(value);
        }
        return res;
    }

    @Override
    public TopicNamespaceType getTopicNamespace() {
        return this.topicNamespace;
    }

    @Override
    public TopicSetType getTopicSet() {
        return this.topicSet;
    }

    @Override
    public TopicsManagerEngine getTopicsManagerEngine() {
        return this.topicsManagerEngine;
    }

    @Override
    public SubscriptionManagerEngine getSubscriptionManagerEngine() {
        return this.subscriptionManagerEngine;
    }

    @Override
    public NotificationProducerEngine getNotificationProducerEngine() {
        return this.notificationProducerEngine;
    }

    @Override
    public List<String> getSupportedTopics() {
        return this.supportedTopics;
    }

    static {
        Wsnb4ServUtils.initModelFactories((WsrfbfModelFactory)new WsrfbfModelFactoryImpl(), (WsrfrModelFactory)new WsrfrModelFactoryImpl(), (WsrfrlModelFactory)new WsrfrlModelFactoryImpl(), (WsrfrpModelFactory)new WsrfrpModelFactoryImpl(), (WstopModelFactory)new WstopModelFactoryImpl(), (WsnbModelFactory)new WsnbModelFactoryImpl());
    }
}

