/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.resources.service;

import com.petalslink.easyresources.execution_environment_connection_api._1.GetAdditionalContent;
import com.petalslink.easyresources.execution_environment_connection_api._1.GetAdditionalContentResponse;
import com.petalslink.easyresources.execution_environment_connection_api._1.GetContent;
import com.petalslink.easyresources.execution_environment_connection_api._1.GetContentResponse;
import com.petalslink.easyresources.execution_environment_connection_api._1.GetResourceIdentifiers;
import com.petalslink.easyresources.execution_environment_connection_api._1.GetResourceIdentifiersResponse;
import com.petalslink.easyresources.execution_environment_connection_api._1_0.ExecutionEnvironmentManager;
import com.petalslink.easyresources.execution_environment_connection_api._1_0.GetAdditionalContentFault;
import com.petalslink.easyresources.execution_environment_connection_api._1_0.GetContentFault;
import com.petalslink.easyresources.execution_environment_connection_api._1_0.GetExecutionEnvironmentInformationFault;
import com.petalslink.easyresources.execution_environment_connection_api._1_0.GetResourceIdentifiersFault;
import com.petalslink.easyresources.execution_environment_connection_model.ExecutionEnvironmentInformationType;
import com.petalslink.easyresources.execution_environment_connection_model.ExecutionEnvironmentInformationTypeType;
import com.petalslink.easyresources.execution_environment_connection_model.InterfaceConnector;
import com.petalslink.easyresources.execution_environment_connection_model.ObjectFactory;
import com.petalslink.easyresources.execution_environment_connection_model.ResourceIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.XMLUtil;
import org.petalslink.dsb.jbi.Adapter;
import org.petalslink.dsb.kernel.api.DSBConfigurationService;
import org.petalslink.dsb.kernel.resources.service.ResourceIdBuilder;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ExecutionEnvironmentManager.class)})
public class ExecutionEnvironmentManagerService
implements ExecutionEnvironmentManager,
BindingController,
LifeCycleController {
    private LoggerFactory loggerFactory;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    private EndpointRegistry endpointRegistry;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="dsbconfiguration", signature=DSBConfigurationService.class)
    private DSBConfigurationService dsbConfigurationService;
    private Logger logger;
    private LoggingUtil log;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public GetAdditionalContentResponse getAdditionalContent(GetAdditionalContent getAdditionalContent) throws GetAdditionalContentFault {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Got a getAdditionalContent call");
        }
        GetAdditionalContentResponse getAdditionalContentResponse = new GetAdditionalContentResponse();
        org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint = this.getEndpoint(getAdditionalContent.getResourceIdentifier().getId());
        if (serviceEndpoint == null) {
            throw new GetAdditionalContentFault(String.format("Impossible to find endpoint corresponding to this qname: %s", getAdditionalContent.getResourceIdentifier().getId()));
        }
        String string = getAdditionalContent.getId();
        Document document = this.getDescription(serviceEndpoint.getDescription());
        Document document2 = this.getImport(document, string);
        if (document2 == null) {
            throw new GetAdditionalContentFault(String.format("Impossible to find import corresponding to %s on endpoint %s", string, getAdditionalContent.getResourceIdentifier().getId()));
        }
        getAdditionalContentResponse.setAny((Object)document2.getDocumentElement());
        return getAdditionalContentResponse;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public GetResourceIdentifiersResponse getResourceIdentifiers(GetResourceIdentifiers getResourceIdentifiers) throws GetResourceIdentifiersFault {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Got a getResourceIdentifiers call");
        }
        GetResourceIdentifiersResponse getResourceIdentifiersResponse = new GetResourceIdentifiersResponse();
        List<org.petalslink.dsb.api.ServiceEndpoint> list = null;
        try {
            list = this.getEndpoints();
        }
        catch (RegistryException registryException) {
            registryException.printStackTrace();
            throw new GetResourceIdentifiersFault("Error while trying to get endpoints from infrastructure");
        }
        for (org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint : list) {
            ResourceIdentifier resourceIdentifier = new ResourceIdentifier();
            resourceIdentifier.setId(ResourceIdBuilder.getId(serviceEndpoint));
            resourceIdentifier.setResourceType("endpoint");
            getResourceIdentifiersResponse.getResourceIdentifier().add(resourceIdentifier);
        }
        return getResourceIdentifiersResponse;
    }

    public GetContentResponse getContent(GetContent getContent) throws GetContentFault {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Got a getContent call");
        }
        GetContentResponse getContentResponse = new GetContentResponse();
        org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint = this.getEndpoint(getContent.getResourceIdentifier().getId());
        if (serviceEndpoint == null) {
            throw new GetContentFault(String.format("Impossible to find endpoint corresponding to this qname: %s", getContent.getResourceIdentifier().getId()));
        }
        String string = serviceEndpoint.getDescription();
        if (string == null) {
            throw new GetContentFault(String.format("No service description found for endpoint: %s", getContent.getResourceIdentifier().getId()));
        }
        Document document = this.getDescription(serviceEndpoint.getDescription());
        if (document == null) {
            throw new GetContentFault("Can not generate WSDL document from endpoint description");
        }
        getContentResponse.setAny((Object)document.getDocumentElement());
        return getContentResponse;
    }

    public ExecutionEnvironmentInformationType getExecutionEnvironmentInformation() throws GetExecutionEnvironmentInformationFault {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Got a getExecutionEnvironmentInformation call");
        }
        ExecutionEnvironmentInformationType executionEnvironmentInformationType = new ExecutionEnvironmentInformationType();
        String string = this.configurationService.getContainerConfiguration().getName();
        String string2 = "1.0-SNAPSHOT";
        executionEnvironmentInformationType.setName(string);
        executionEnvironmentInformationType.setType(ExecutionEnvironmentInformationTypeType.ESB);
        executionEnvironmentInformationType.setVersion(string2);
        ObjectFactory objectFactory = new ObjectFactory();
        InterfaceConnector interfaceConnector = new InterfaceConnector();
        interfaceConnector.setId(objectFactory.createInterfaceConnectorId("resourcesSubscriptionEndpoint"));
        interfaceConnector.setInterfaceName(new QName("http://www.petalslink.com/wsn/service/WsnProducer", "NotificationProducer"));
        interfaceConnector.setEndpointAddress(this.getProducerEndpoint());
        executionEnvironmentInformationType.getInterfaceConnector().add(interfaceConnector);
        InterfaceConnector interfaceConnector2 = new InterfaceConnector();
        interfaceConnector2.setId(objectFactory.createInterfaceConnectorId("resourcesUnSubscriptionEndpoint"));
        interfaceConnector2.setInterfaceName(new QName("http://www.petalslink.com/wsn/service/WsnProducer", "PausableSubscriptionManager"));
        interfaceConnector2.setEndpointAddress(this.getProducerEndpoint());
        executionEnvironmentInformationType.getInterfaceConnector().add(interfaceConnector2);
        return executionEnvironmentInformationType;
    }

    private Document getDescription(String string) {
        try {
            Description description = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(XMLUtil.createDocumentFromString((String)string));
            return WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter().getDocument(description);
        }
        catch (WSDL4ComplexWsdlException wSDL4ComplexWsdlException) {
            wSDL4ComplexWsdlException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return null;
    }

    private Document getImport(Document document, String string) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Try to get import from %s", string));
        }
        try {
            Description description = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(document);
            Map map = description.deleteImportedDocumentsInWsdl();
            if (map != null) {
                for (URI uRI : map.keySet()) {
                    System.out.printf("Import URI %s", uRI.toString());
                    if (!uRI.toString().equals(string)) continue;
                    return (Document)map.get(uRI);
                }
            }
        }
        catch (WSDL4ComplexWsdlException wSDL4ComplexWsdlException) {
            wSDL4ComplexWsdlException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return null;
    }

    private org.petalslink.dsb.api.ServiceEndpoint getEndpoint(String string) {
        List list;
        org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint = null;
        try {
            list = this.endpointRegistry.getEndpoints();
        }
        catch (RegistryException registryException) {
            registryException.printStackTrace();
            return null;
        }
        for (ServiceEndpoint serviceEndpoint2 : list) {
            if (!serviceEndpoint2.getEndpointName().equals(ResourceIdBuilder.getEndpointName(string)) || !serviceEndpoint2.getLocation().getComponentName().equals(ResourceIdBuilder.getComponent(string)) || !serviceEndpoint2.getLocation().getContainerName().equals(ResourceIdBuilder.getContainer(string)) || !serviceEndpoint2.getLocation().getSubdomainName().equals(ResourceIdBuilder.getDomain(string))) continue;
            return Adapter.createServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint2);
        }
        return serviceEndpoint;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("dsbconfiguration")) {
            if (!DSBConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBConfigurationService.class.getName());
            }
            this.dsbConfigurationService = (DSBConfigurationService)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("endpoint");
        arrayList.add("configuration");
        arrayList.add("dsbconfiguration");
        return arrayList.toArray(new String[0]);
    }

    private String getProducerEndpoint() {
        return String.valueOf(this.dsbConfigurationService.getWSKernelBaseURL()) + "NotificationProducer";
    }

    private String getNotificationEndpoint() {
        return String.valueOf(this.dsbConfigurationService.getWSKernelBaseURL()) + "NotificationConsumer";
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("dsbconfiguration")) {
            return this.dsbConfigurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private List<org.petalslink.dsb.api.ServiceEndpoint> getEndpoints() throws RegistryException {
        ArrayList<org.petalslink.dsb.api.ServiceEndpoint> arrayList = new ArrayList<org.petalslink.dsb.api.ServiceEndpoint>();
        List list = this.endpointRegistry.getEndpoints();
        for (ServiceEndpoint serviceEndpoint : list) {
            org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint2 = Adapter.createServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)serviceEndpoint);
            arrayList.add(serviceEndpoint2);
        }
        return arrayList;
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("dsbconfiguration")) {
            this.dsbConfigurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

