/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.resources.service;

import com.petalslink.easyresources.execution_environment_connection_model.ObjectFactory;
import com.petalslink.easyresources.execution_environment_connection_model.ResourceIdentifier;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.XMLUtil;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.kernel.pubsub.service.NotificationCenter;
import org.petalslink.dsb.kernel.resources.service.ResourceIdBuilder;
import org.petalslink.dsb.kernel.resources.service.utils.SOAException;
import org.petalslink.dsb.kernel.resources.service.utils.SOAJAXBContext;
import org.petalslink.dsb.notification.commons.NotificationException;
import org.petalslink.dsb.notification.commons.api.NotificationSender;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@org.petalslink.dsb.annotations.registry.RegistryListener
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=org.petalslink.dsb.kernel.api.messaging.RegistryListener.class)})
public class RegistryListener
implements BindingController,
LifeCycleController,
org.petalslink.dsb.kernel.api.messaging.RegistryListener {
    private Logger logger;
    private LoggingUtil log;
    public static final QName topicUsed = new QName("http://www.petalslink.org/resources/event/1.0", "CreationResourcesTopic", "tns");
    public static final String dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";
    private SOAJAXBContext context;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        try {
            this.context = SOAJAXBContext.getInstance();
            this.context.addOtherObjectFactory(ObjectFactory.class);
        }
        catch (SOAException sOAException) {}
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void onRegister(ServiceEndpoint serviceEndpoint) throws DSBException {
        NotificationCenter notificationCenter;
        Document document;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"A new endpoint has been registered, send a notification to the engine");
        }
        ResourceIdentifier resourceIdentifier = new ResourceIdentifier();
        resourceIdentifier.setId(ResourceIdBuilder.getId(serviceEndpoint));
        resourceIdentifier.setResourceType("endpoint");
        try {
            document = SOAJAXBContext.getInstance().unmarshallAnyElement(resourceIdentifier);
        }
        catch (SOAException sOAException) {
            throw new DSBException((Throwable)sOAException);
        }
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)XMLUtil.createStringFromDOMDocument((Node)document));
            }
            catch (TransformerException transformerException) {}
        }
        if ((notificationCenter = NotificationCenter.get()) == null) {
            throw new DSBException("Can not get the notification center to send new resource notification...");
        }
        NotificationSender notificationSender = notificationCenter.getSender();
        if (notificationSender == null) {
            throw new DSBException("Can not get the notification sender from the notification center...");
        }
        try {
            notificationSender.notify(document, topicUsed, dialect);
        }
        catch (NotificationException notificationException) {
            throw new DSBException((Throwable)notificationException);
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void onUnregister(ServiceEndpoint serviceEndpoint) throws DSBException {
    }

    public String getName() {
        return "Theregistrylistenerforexecenv";
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

