/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.resources.service.utils;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.petalslink.dsb.kernel.resources.service.utils.SOAException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DOMUtil {
    private DocumentBuilderFactory domBuilder = DocumentBuilderFactory.newInstance();
    private static DOMUtil INSTANCE;

    private DOMUtil() {
        this.domBuilder.setNamespaceAware(true);
    }

    public static DOMUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DOMUtil();
        }
        return INSTANCE;
    }

    public Element getFirstElement(Element element) {
        Element element2 = null;
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n).getNodeType() == 1) {
                    element2 = (Element)nodeList.item(n);
                    break;
                }
                ++n;
            }
        }
        return element2;
    }

    public Document createDocumentFromElement(Element element) throws ParserConfigurationException {
        Document document = this.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        document.appendChild((Element)document.importNode(element.cloneNode(true), true));
        return document;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.domBuilder;
    }

    public Document convertFirstElementIntoDocument(DocumentBuilderFactory documentBuilderFactory, Document document) throws SOAException {
        Document document2 = null;
        try {
            document2 = documentBuilderFactory.newDocumentBuilder().newDocument();
            Element element = this.getFirstElement(document.getDocumentElement());
            if (element != null) {
                document2.appendChild(document2.importNode(element.cloneNode(true), true));
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SOAException(parserConfigurationException);
        }
        return document2;
    }
}

