/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;

public abstract class AbstractJBIAntTask
extends Task {
    public static final String DEFAULT_JMX_PORT = "7700";
    public static final String DEFAULT_JMX_HOST = "localhost";
    protected boolean failOnError = true;
    protected String host = "localhost";
    protected String port = "7700";
    protected String username;
    protected String password;
    protected static Map<String, JMXClient> jmxClients = new ConcurrentHashMap<String, JMXClient>();

    public void execute() throws BuildException {
        block2: {
            try {
                this.doTask();
            }
            catch (Throwable e) {
                if (!this.isFailOnError()) break block2;
                throw new BuildException(e.getMessage(), e.getCause());
            }
        }
    }

    public abstract void doTask() throws Exception;

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMXClient getJMXClient() throws NumberFormatException, ConnectionErrorException {
        JMXClient petalsJMXClient;
        Map<String, JMXClient> map = jmxClients;
        synchronized (map) {
            String key = this.getConnectionKey();
            petalsJMXClient = jmxClients.get(key);
            if (petalsJMXClient == null) {
                petalsJMXClient = new JMXClient(this.host, Integer.valueOf(this.port), this.username, this.password);
                jmxClients.put(key, petalsJMXClient);
            }
        }
        return petalsJMXClient;
    }

    private final String getConnectionKey() {
        return this.host + this.port + this.username + this.password;
    }
}

