/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractInstallerAntTask;
import org.ow2.petals.jmx.ConfigurationInstallerComponentClient;
import org.ow2.petals.jmx.InstallerComponentClient;
import org.ow2.petals.jmx.exception.AttributeErrorException;

public class InstallComponentTask
extends AbstractInstallerAntTask {
    private static final Hashtable<String, Class<?>> primitiveClasses = new Hashtable(12);
    private final List<Param> nestedParams = new ArrayList<Param>();
    private String params;
    private Set<MBeanAttributeInfo> configurationAttributes;

    public void doTask() throws Exception {
        URL fileURL = this.validateFileParameter();
        InstallerComponentClient installer = this.getJMXClient().getInstallationServiceClient().loadNewInstaller(fileURL);
        Properties propertiesParams = this.loadProperties();
        if (this.nestedParams.size() > 0 || propertiesParams.size() > 0) {
            this.log(this.nestedParams.size() + propertiesParams.size() + " installation parameters will be set to the installer");
            ConfigurationInstallerComponentClient installerConfigurationMBean = installer.getConfigurationInstallerClient();
            if (installerConfigurationMBean != null) {
                this.configurationAttributes = installerConfigurationMBean.getAttributes().keySet();
                this.setConnectionAttributeFromPropertiesFile(installerConfigurationMBean, propertiesParams);
                this.setConnectionAttributeFromNestedParam(installerConfigurationMBean);
            } else {
                this.log("No installer configuration MBean proposed by the installer MBean!", LogLevel.WARN.getLevel());
            }
        }
        installer.install();
        this.log("Component '" + installer.getMBeanName().getKeyProperty("name") + "' installed");
    }

    private Properties loadProperties() throws IOException {
        Properties props = new Properties();
        if (this.params != null) {
            props.load(new FileInputStream(this.params));
        }
        return props;
    }

    private void setConnectionAttributeFromPropertiesFile(ConfigurationInstallerComponentClient installerConfigurationMBean, Properties propertiesParams) throws Exception {
        for (Map.Entry<Object, Object> entry : propertiesParams.entrySet()) {
            this.log("Setting attribute from properties " + (String)entry.getKey() + " = " + (String)entry.getValue());
            this.setAttribute(installerConfigurationMBean, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setConnectionAttributeFromNestedParam(ConfigurationInstallerComponentClient installerConfigurationMBean) throws Exception {
        for (Param p : this.nestedParams) {
            this.log("Setting attribute " + p.getName() + " = " + p.getValue());
            this.setAttribute(installerConfigurationMBean, p.getName(), p.getValue());
        }
    }

    private void setAttribute(ConfigurationInstallerComponentClient installerConfigurationMBean, String key, String value) throws AttributeErrorException {
        Object castedValue = null;
        boolean found = false;
        for (MBeanAttributeInfo attributeInfo : this.configurationAttributes) {
            if (!attributeInfo.getName().equals(key)) continue;
            if (primitiveClasses.containsKey(attributeInfo.getType())) {
                try {
                    Class<?> primitiveClass = primitiveClasses.get(attributeInfo.getType());
                    Method valueOfMethod = primitiveClass.getMethod("valueOf", String.class);
                    castedValue = valueOfMethod.invoke(null, value);
                }
                catch (SecurityException e) {
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            } else if (attributeInfo.getType().equals(String.class.getName())) {
                castedValue = value;
            }
            found = true;
            break;
        }
        if (castedValue == null) {
            if (found) {
                throw new RuntimeException("Failed to identify primitive type of parameter '" + key + "'");
            }
            throw new RuntimeException("Failed to identify parameter '" + key + "'");
        }
        installerConfigurationMBean.setAttribute(key, castedValue);
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public Param createParam() {
        Param param = new Param();
        this.nestedParams.add(param);
        return param;
    }

    static {
        primitiveClasses.put(Boolean.class.getName(), Boolean.class);
        primitiveClasses.put(Boolean.TYPE.getName(), Boolean.class);
        primitiveClasses.put(Short.class.getName(), Short.class);
        primitiveClasses.put(Short.TYPE.getName(), Short.class);
        primitiveClasses.put(Integer.class.getName(), Integer.class);
        primitiveClasses.put(Integer.TYPE.getName(), Integer.class);
        primitiveClasses.put(Long.class.getName(), Long.class);
        primitiveClasses.put(Long.TYPE.getName(), Long.class);
        primitiveClasses.put(Float.class.getName(), Float.class);
        primitiveClasses.put(Float.TYPE.getName(), Float.class);
        primitiveClasses.put(Double.class.getName(), Double.class);
        primitiveClasses.put(Double.TYPE.getName(), Double.class);
    }

    public static class Param {
        private String name;
        private String value;

        public Param() {
            this("", "");
        }

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

