/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.task;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.LogLevel;
import org.ow2.petals.ant.AbstractJBIAntTask;
import org.ow2.petals.jmx.InstallerComponentClient;

public class UninstallComponentTask
extends AbstractJBIAntTask {
    private static final Hashtable<String, Class<?>> primitiveClasses = new Hashtable(12);
    private List<Param> nestedParams = new ArrayList<Param>();
    private String params;
    private MBeanAttributeInfo[] attributeInfos;
    private String name;

    public void doTask() throws Exception {
        if (this.name == null) {
            throw new BuildException("Missing attribute 'name'");
        }
        InstallerComponentClient installer = this.getJMXClient().getInstallationServiceClient().loadInstaller(this.name);
        ObjectName installerConfigurationMBeanName = installer.getMBeanName();
        if (this.nestedParams.size() > 0 || this.params != null) {
            this.log(String.valueOf(this.nestedParams.size()) + " parameters to be set to the installer configuration MBean");
            if (installerConfigurationMBeanName != null) {
                MBeanServerConnection mbeanServerConnection = this.getJMXClient().getMBeanServerConnection();
                this.getConfigurationAttributes(mbeanServerConnection, installerConfigurationMBeanName);
                this.setConnectionAttributeFromPropertiesFile(mbeanServerConnection, installerConfigurationMBeanName);
                this.setConnectionAttributeFromNestedParam(mbeanServerConnection, installerConfigurationMBeanName);
            } else {
                this.log("No installer configuration MBean proposed by the installer MBean!", LogLevel.WARN.getLevel());
            }
        }
        installer.uninstall();
        this.getJMXClient().getInstallationServiceClient().unloadInstaller(this.name);
        this.log("Component '" + this.name + "' uninstalled");
    }

    public void setName(String name) {
        this.name = name;
    }

    private Properties loadProperties() throws IOException {
        Properties props = new Properties();
        if (this.params != null) {
            props.load(new FileInputStream(this.params));
        }
        return props;
    }

    private void setConnectionAttributeFromPropertiesFile(MBeanServerConnection connection, ObjectName configurationMBean) throws Exception {
        Properties props = this.loadProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.log("Setting attribute from properties " + (String)entry.getKey() + " = " + (String)entry.getValue());
            this.setAttribute(connection, configurationMBean, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setConnectionAttributeFromNestedParam(MBeanServerConnection connection, ObjectName configurationMBean) throws Exception {
        for (Param p : this.nestedParams) {
            this.log("Setting attribute " + p.getName() + " = " + p.getValue());
            this.setAttribute(connection, configurationMBean, p.getName(), p.getValue());
        }
    }

    private void setAttribute(MBeanServerConnection connection, ObjectName configurationMBean, String key, String value) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        Object castedValue = null;
        boolean found = false;
        for (MBeanAttributeInfo attributeInfo : this.attributeInfos) {
            if (!attributeInfo.getName().equals(key)) continue;
            if (primitiveClasses.containsKey(attributeInfo.getType())) {
                try {
                    Class<?> primitiveClass = primitiveClasses.get(attributeInfo.getType());
                    Method valueOfMethod = primitiveClass.getMethod("valueOf", String.class);
                    castedValue = valueOfMethod.invoke(null, value);
                }
                catch (SecurityException e) {
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            } else if (attributeInfo.getType().equals(String.class.getName())) {
                castedValue = value;
            }
            found = true;
            break;
        }
        if (castedValue == null) {
            if (found) {
                throw new RuntimeException("Failed to identify primitive type of parameter '" + key + "'");
            }
            throw new RuntimeException("Failed to identify parameter '" + key + "'");
        }
        Attribute attribute = new Attribute(key, castedValue);
        connection.setAttribute(configurationMBean, attribute);
    }

    private void getConfigurationAttributes(MBeanServerConnection connection, ObjectName configurationMBean) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo mbeanInfo = connection.getMBeanInfo(configurationMBean);
        this.attributeInfos = mbeanInfo.getAttributes();
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public Param createParam() {
        Param param = new Param();
        this.nestedParams.add(param);
        return param;
    }

    static {
        primitiveClasses.put(Boolean.class.getName(), Boolean.class);
        primitiveClasses.put(Boolean.TYPE.getName(), Boolean.class);
        primitiveClasses.put(Short.class.getName(), Short.class);
        primitiveClasses.put(Boolean.TYPE.getName(), Short.class);
        primitiveClasses.put(Integer.class.getName(), Integer.class);
        primitiveClasses.put(Integer.TYPE.getName(), Integer.class);
        primitiveClasses.put(Long.class.getName(), Long.class);
        primitiveClasses.put(Long.TYPE.getName(), Long.class);
        primitiveClasses.put(Float.class.getName(), Float.class);
        primitiveClasses.put(Float.TYPE.getName(), Float.class);
        primitiveClasses.put(Double.class.getName(), Double.class);
        primitiveClasses.put(Double.TYPE.getName(), Double.class);
    }

    public static class Param {
        private String name;
        private String value;

        public Param() {
            this("", "");
        }

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

