/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ant.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;

public class ZipUtil {
    public static final void addFile(ZipOutputStream zipOutputStream, InputStream inputStream, String zipEntryName) throws IOException {
        ZipEntry zipEntry = new ZipEntry(zipEntryName);
        ZipUtil.putEntry(zipOutputStream, inputStream, zipEntry);
    }

    public static final void addFile(ZipOutputStream zipOutputStream, InputStream inputStream, String zipEntryName, long zipEntryTime) throws IOException {
        ZipEntry zipEntry = new ZipEntry(zipEntryName);
        zipEntry.setTime(zipEntryTime);
        ZipUtil.putEntry(zipOutputStream, inputStream, zipEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void putEntry(ZipOutputStream zipOutputStream, InputStream inputStream, ZipEntry zipEntry) throws IOException {
        DataInputStream dis = new DataInputStream(inputStream);
        try {
            byte[] content = new byte[dis.available()];
            dis.readFully(content);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(content);
            zipOutputStream.closeEntry();
        }
        finally {
            dis.close();
        }
    }

    public static final void copyAndUpdateZipFile(ZipFile zipInputFile, ZipOutputStream zipOutputStream, ZipEntryCallback callback) throws IOException, JBIDescriptorException {
        Enumeration<? extends ZipEntry> zipEntries = zipInputFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            ZipEntry newZipEntry = new ZipEntry(zipEntry.getName());
            newZipEntry.setComment(zipEntry.getComment());
            newZipEntry.setTime(zipEntry.getTime());
            ZipUtil.putEntry(zipOutputStream, callback.onZipEntry(newZipEntry, zipInputFile.getInputStream(zipEntry)), newZipEntry);
        }
    }

    public static interface ZipEntryCallback {
        public InputStream onZipEntry(ZipEntry var1, InputStream var2) throws IOException, JBIDescriptorException;
    }
}

