/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.rest;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.rest.RESTServiceExposer;
import org.petalslink.dsb.kernel.rest.RESTServiceInformationBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RESTServiceExposer.class)})
public class CXFRESTServiceExposerImpl
implements BindingController,
LifeCycleController,
RESTServiceExposer {
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    private Server server;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.start();
        if (this.server != null) {
            this.server.stop();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Set<RESTServiceInformationBean> expose(Set<RESTServiceInformationBean> set) {
        HashSet<RESTServiceInformationBean> hashSet = new HashSet<RESTServiceInformationBean>();
        String string = "http://" + this.configurationService.getContainerConfiguration().getHost() + ":" + this.configurationService.getContainerConfiguration().getWebservicePort() + "/rest/kernel/";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (RESTServiceInformationBean object2 : set) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding REST service : " + object2));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Kernel service " + object2.componentName + " is exposed as REST service at " + string + object2.componentName));
            }
            arrayList.add(object2.implem);
            hashSet.add(object2);
        }
        JAXRSServerFactoryBean jAXRSServerFactoryBean = new JAXRSServerFactoryBean();
        jAXRSServerFactoryBean.setBindingId("http://apache.org/cxf/binding/jaxrs");
        jAXRSServerFactoryBean.setAddress(string);
        jAXRSServerFactoryBean.setServiceBeans(arrayList);
        this.server = jAXRSServerFactoryBean.create();
        this.log.info((Object)("REST kernel services are exposed under " + string));
        return hashSet;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

