/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import spoon.processing.Builder;
import spoon.processing.Environment;
import spoon.processing.ProcessingManager;
import spoon.reflect.CoreFactory;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.support.DefaultCoreFactory;
import spoon.support.RuntimeProcessingManager;
import spoon.support.StandardEnvironment;
import spoon.support.util.BasicCompilationUnit;
import spoon.support.util.JDTCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpoonClassLoader
extends ClassLoader {
    private CoreFactory coreFactory;
    private Environment environment;
    private Factory factory;
    private ProcessingManager processing;
    private File sourcePath;
    private Map<String, Class> classcache = new TreeMap<String, Class>();

    public SpoonClassLoader() {
    }

    public SpoonClassLoader(ClassLoader parent) {
        super(parent);
    }

    private Class createClass(String qualifiedName) {
        try {
            this.processJavaFile(qualifiedName);
            return this.classcache.get(qualifiedName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CoreFactory getCoreFactory() {
        if (this.coreFactory == null) {
            this.coreFactory = new DefaultCoreFactory();
        }
        return this.coreFactory;
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new StandardEnvironment();
        }
        return this.environment;
    }

    public Factory getFactory() {
        if (this.factory == null) {
            this.factory = new Factory(this.getCoreFactory(), this.getEnvironment());
        }
        return this.factory;
    }

    public ProcessingManager getProcessingManager() {
        if (this.processing == null) {
            this.processing = new RuntimeProcessingManager(this.getFactory());
        }
        return this.processing;
    }

    public File getSourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new File("");
        }
        return this.sourcePath;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.classcache.containsKey(name)) {
            return this.classcache.get(name);
        }
        Class<?> clas = null;
        clas = this.createClass(name);
        if (clas == null) {
            clas = this.findSystemClass(name);
        }
        if (clas == null) {
            throw new ClassNotFoundException(name);
        }
        return clas;
    }

    private void processJavaFile(String qualifiedName) throws Exception {
        CtSimpleType c = this.getFactory().Type().get(qualifiedName);
        if (c == null) {
            File f = this.resolve(qualifiedName);
            if (f == null || !f.exists()) {
                throw new ClassNotFoundException(qualifiedName);
            }
            Builder builder = this.getFactory().getBuilder();
            builder.addInputSource(f);
            builder.build();
            c = this.getFactory().Type().get(qualifiedName);
        }
        if (c == null) {
            throw new ClassNotFoundException(qualifiedName);
        }
        this.getProcessingManager().process(c);
        DefaultJavaPrettyPrinter printer = new DefaultJavaPrettyPrinter(this.getEnvironment());
        printer.scan(c);
        String[] tmp = c.getQualifiedName().split("[.]");
        char[][] pack = new char[tmp.length - 1][];
        for (int i = 0; i < tmp.length - 1; ++i) {
            pack[i] = tmp[i].toCharArray();
        }
        BasicCompilationUnit unit = new BasicCompilationUnit(printer.toString().toCharArray(), pack, c.getSimpleName() + ".java");
        JDTCompiler comp = new JDTCompiler();
        comp.compile(new ICompilationUnit[]{unit});
        for (ClassFile f : comp.getClassFiles()) {
            String name = new String(f.fileName()).replace('/', '.');
            Class<?> cl = this.defineClass(name, f.getBytes(), 0, f.getBytes().length);
            this.classcache.put(name, cl);
        }
    }

    private File resolve(String qualifiedName) {
        String[] path;
        File current = this.sourcePath;
        for (String p : path = qualifiedName.split("[.]")) {
            for (File f : current.listFiles()) {
                if (!f.getName().equals(p) && !f.getName().equals(p + ".java")) continue;
                current = f;
            }
        }
        if (!current.isDirectory()) {
            return current;
        }
        return null;
    }

    public void setCoreFactory(CoreFactory coreFactory) {
        this.coreFactory = coreFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    public void setProcessingManager(ProcessingManager processing) {
        this.processing = processing;
    }

    public void setSourcePath(File sourcePath) {
        this.sourcePath = sourcePath;
    }
}

