/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.eval;

import java.util.HashMap;
import java.util.Map;
import spoon.reflect.eval.SymbolicEvaluator;
import spoon.reflect.eval.SymbolicInstance;
import spoon.reflect.reference.CtTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolicHeap {
    private Map<String, SymbolicInstance> statefullAbstractInstances = new HashMap<String, SymbolicInstance>();
    private Map<String, SymbolicInstance> statelessAbstractInstances = new HashMap<String, SymbolicInstance>();

    public SymbolicHeap() {
    }

    public SymbolicHeap(SymbolicHeap heap) {
        this.statelessAbstractInstances.putAll(heap.statelessAbstractInstances);
        for (Map.Entry<String, SymbolicInstance> e : heap.statefullAbstractInstances.entrySet()) {
            this.statefullAbstractInstances.put(e.getKey(), new SymbolicInstance(e.getValue()));
        }
    }

    public String toString() {
        return "stateful=" + this.statefullAbstractInstances + " stateless=" + this.statelessAbstractInstances;
    }

    public void dump() {
        System.out.println("\tHeap:");
        System.out.println("\t - stateful: " + this.statefullAbstractInstances);
        System.out.println("\t - stateless: " + this.statelessAbstractInstances);
    }

    public <T> SymbolicInstance<T> getType(SymbolicEvaluator evaluator, CtTypeReference<T> concreteType) {
        SymbolicInstance<T> type = this.get(SymbolicInstance.getSymbolId(concreteType, "type"));
        if (type == null) {
            type = new SymbolicInstance<T>(evaluator, concreteType, true);
            this.store(type);
        }
        return type;
    }

    public void store(SymbolicInstance instance) {
        if (instance.isStateful()) {
            this.statefullAbstractInstances.put(instance.getId(), instance);
        } else {
            this.statelessAbstractInstances.put(instance.getId(), instance);
        }
    }

    public <T> SymbolicInstance<T> get(String id) {
        SymbolicInstance i = this.statelessAbstractInstances.get(id);
        if (i == null) {
            i = this.statefullAbstractInstances.get(id);
        }
        return i;
    }

    public void clear() {
        this.statefullAbstractInstances.clear();
    }
}

