/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import spoon.reflect.Factory;
import spoon.reflect.code.CtBlock;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.ExecutableFactory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorFactory
extends ExecutableFactory {
    private static final long serialVersionUID = 1L;

    public ConstructorFactory(Factory factory) {
        super(factory);
    }

    public CtConstructor create(CtClass<?> target, CtConstructor source) {
        CtConstructor newConstructor = this.factory.Core().clone(source);
        target.getConstructors().add(newConstructor);
        newConstructor.setParent(target);
        return newConstructor;
    }

    public <T> CtConstructor<T> create(CtClass<?> target, CtMethod<T> source) {
        CtMethod<T> method = this.factory.Core().clone(source);
        CtConstructor newConstructor = this.factory.Core().createConstructor();
        newConstructor.setAnnotations(method.getAnnotations());
        newConstructor.setBody(method.getBody());
        newConstructor.setDocComment(method.getDocComment());
        newConstructor.setFormalTypeParameters(method.getFormalTypeParameters());
        newConstructor.setModifiers(method.getModifiers());
        newConstructor.setParameters(method.getParameters());
        this.setParent(newConstructor, method.getAnnotations(), method.getBody(), method.getParameters(), method.getFormalTypeParameters());
        target.getConstructors().add(newConstructor);
        newConstructor.setParent(target);
        return newConstructor;
    }

    public <T> CtConstructor<T> create(CtClass<?> target, Set<ModifierKind> modifiers, List<CtParameter<?>> parameters, Set<CtTypeReference<? extends Throwable>> thrownTypes) {
        CtConstructor constructor = this.factory.Core().createConstructor();
        constructor.setModifiers(modifiers);
        constructor.setParent(target);
        constructor.setParameters(parameters);
        constructor.setThrownTypes(thrownTypes);
        this.setParent(constructor, parameters);
        target.getConstructors().add(constructor);
        return constructor;
    }

    public <T> CtConstructor<T> create(CtClass<T> target, Set<ModifierKind> modifiers, List<CtParameter<?>> parameters, Set<CtTypeReference<? extends Throwable>> thrownTypes, CtBlock<T> body) {
        CtConstructor<T> constructor = this.create(target, modifiers, parameters, thrownTypes);
        constructor.setBody(body);
        body.setParent(constructor);
        return constructor;
    }

    public <T> CtExecutableReference<T> createReference(CtConstructor<T> c) {
        return this.factory.Executable().createReference(c);
    }

    public <T> CtExecutableReference<T> createReference(Constructor constructor) {
        return this.createReference(this.factory.Type().createReference(constructor.getDeclaringClass()), null, constructor.getName(), this.factory.Type().createReferences(Arrays.asList(constructor.getParameterTypes())));
    }
}

