/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaIdentifiers {
    IMPORT,
    PACKAGE,
    INTERFACE,
    CLASS,
    ENUM,
    SUPER,
    THIS,
    ASSERT,
    EXTENDS,
    BREAK,
    CASE,
    CATCH,
    CONTINUE,
    DO,
    FOR,
    IF,
    NEW,
    RETURN,
    SWITCH,
    THROW,
    TRY,
    WHILE,
    PUBLIC,
    PROTECTED,
    PRIVATE,
    ABSTRACT,
    STATIC,
    FINAL,
    TRANSIENT,
    VOLATILE,
    SYNCHRONIZED,
    NATIVE,
    STRICTFP;

    public static Set<String> KEYWORDS;

    static boolean isJavaIdentifier(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalJavaIdentifier(String string) {
        if (string == null) {
            return false;
        }
        return !KEYWORDS.contains(string) && JavaIdentifiers.isJavaIdentifier(string);
    }

    public static boolean isLegalJavaPackageIdentifier(String string) {
        if (string == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(string, ".");
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (JavaIdentifiers.isLegalJavaIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalJavaExecutableIdentifier(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("<init>")) {
            return true;
        }
        return JavaIdentifiers.isLegalJavaIdentifier(string);
    }

    static {
        KEYWORDS = new HashSet<String>();
        for (JavaIdentifiers kw : Arrays.asList(JavaIdentifiers.values())) {
            KEYWORDS.add(kw.name().toLowerCase());
        }
    }
}

