/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.io.File;
import java.io.Serializable;
import spoon.reflect.declaration.CompilationUnit;
import spoon.reflect.declaration.SourcePosition;

public class SourcePositionImpl
implements SourcePosition,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    int[] lineSeparatorPositions;
    private int sourceStart;
    private int sourceEnd;
    CompilationUnit compilationUnit;

    private int searchLineNumber(int[] startLineIndexes, int position) {
        if (startLineIndexes == null) {
            return 1;
        }
        int length = startLineIndexes.length;
        if (length == 0) {
            return 1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            int start = startLineIndexes[m];
            if (position < start) {
                d = m - 1;
                continue;
            }
            if (position > start) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < startLineIndexes[m]) {
            return m + 1;
        }
        return m + 2;
    }

    private int searchColumnNumber(int[] startLineIndexes, int position) {
        if (startLineIndexes == null) {
            return 1;
        }
        int length = startLineIndexes.length;
        if (length == 0) {
            return 1;
        }
        int i = 0;
        for (i = 0; i < startLineIndexes.length - 1; ++i) {
            if (startLineIndexes[i] >= position || startLineIndexes[i + 1] <= position) continue;
            return position - startLineIndexes[i];
        }
        int tabCount = 0;
        int tabSize = 0;
        if (this.getCompilationUnit() != null) {
            tabSize = this.getCompilationUnit().getFactory().getEnvironment().getTabulationSize();
            String source = this.getCompilationUnit().getOriginalSourceCode();
            for (int j = startLineIndexes[i]; j < position; ++j) {
                if (source.charAt(j) != '\t') continue;
                ++tabCount;
            }
        }
        return position - startLineIndexes[i] - tabCount + tabCount * tabSize;
    }

    public SourcePositionImpl(CompilationUnit compilationUnit, int sourceStart, int sourceEnd, int[] lineSeparatorPositions) {
        this.compilationUnit = compilationUnit;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.lineSeparatorPositions = lineSeparatorPositions;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getColumn() {
        return this.searchColumnNumber(this.lineSeparatorPositions, this.sourceStart);
    }

    public int getEndColumn() {
        return this.searchColumnNumber(this.lineSeparatorPositions, this.sourceEnd);
    }

    public File getFile() {
        if (this.compilationUnit == null) {
            return null;
        }
        return this.compilationUnit.getFile();
    }

    public int getLine() {
        return this.searchLineNumber(this.lineSeparatorPositions, this.sourceStart);
    }

    public int getEndLine() {
        return this.searchLineNumber(this.lineSeparatorPositions, this.sourceEnd);
    }

    public int getSourceEnd() {
        return this.sourceEnd;
    }

    public int getSourceStart() {
        return this.sourceStart;
    }

    public String toString() {
        int ln = this.getLine();
        return ln >= 1 ? this.getFile().getAbsolutePath() + ":" + ln : this.getFile().getAbsolutePath();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourcePosition)) {
            return false;
        }
        SourcePosition s = (SourcePosition)obj;
        return (this.getFile() == null ? s.getFile() == null : this.getFile().equals(s.getFile())) && this.getLine() == s.getLine() && this.getColumn() == s.getColumn();
    }

    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }
}

