/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.reference.CtVariableReferenceImpl;
import spoon.support.util.RtHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtFieldReferenceImpl<T>
extends CtVariableReferenceImpl<T>
implements CtFieldReference<T> {
    private static final long serialVersionUID = 1L;
    CtTypeReference<?> declaringType;
    boolean fina = false;
    boolean stat = false;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtFieldReference(this);
    }

    @Override
    public Member getActualField() {
        try {
            if (this.getDeclaringType().getActualClass().isAnnotation()) {
                return this.getDeclaringType().getActualClass().getDeclaredMethod(this.getSimpleName(), new Class[0]);
            }
            return this.getDeclaringType().getActualClass().getDeclaredField(this.getSimpleName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A annotation = super.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        Class<?> c = this.getDeclaringType().getActualClass();
        if (c.isAnnotation()) {
            for (Method m : RtHelper.getAllMethods(c)) {
                if (!this.getSimpleName().equals(m.getName())) continue;
                m.setAccessible(true);
                return m.getAnnotation(annotationType);
            }
        } else {
            for (Field f : RtHelper.getAllFields(c)) {
                if (!this.getSimpleName().equals(f.getName())) continue;
                f.setAccessible(true);
                return f.getAnnotation(annotationType);
            }
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] annotations = super.getAnnotations();
        if (annotations != null) {
            return annotations;
        }
        Class<?> c = this.getDeclaringType().getActualClass();
        for (Field field : RtHelper.getAllFields(c)) {
            if (!this.getSimpleName().equals(field.getName())) continue;
            field.setAccessible(true);
            return field.getAnnotations();
        }
        for (AccessibleObject accessibleObject : RtHelper.getAllMethods(c)) {
            if (!this.getSimpleName().equals(((Method)accessibleObject).getName())) continue;
            ((Method)accessibleObject).setAccessible(true);
            return accessibleObject.getAnnotations();
        }
        return null;
    }

    @Override
    public CtField<T> getDeclaration() {
        CtSimpleType<?> type = this.declaringType.getDeclaration();
        if (this.declaringType != null && type != null) {
            return type.getField(this.getSimpleName());
        }
        return null;
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public String getQualifiedName() {
        return this.getDeclaringType().getQualifiedName() + "#" + this.getSimpleName();
    }

    @Override
    public boolean isFinal() {
        return this.fina;
    }

    @Override
    public boolean isStatic() {
        return this.stat;
    }

    @Override
    public void setDeclaringType(CtTypeReference<?> declaringType) {
        this.declaringType = declaringType;
    }

    @Override
    public void setFinal(boolean b) {
        this.fina = b;
    }

    @Override
    public void setStatic(boolean stat) {
        this.stat = stat;
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        CtVariable v = this.getDeclaration();
        if (v != null) {
            return v.getModifiers();
        }
        Member m = this.getActualField();
        if (m != null) {
            return RtHelper.getModifiers(m.getModifiers());
        }
        return new TreeSet<ModifierKind>();
    }
}

