/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.naming.ConfigurationException;
import javax.xml.bind.JAXBException;
import org.ow2.petals.jmx.JMXClient;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.jmx.exception.PetalsAdminDoesNotExistException;
import org.ow2.petals.jmx.exception.PetalsAdminServiceErrorException;
import org.ow2.petals.launcher.AbstractLauncher;
import org.ow2.petals.topology.TopologyBuilder;
import org.ow2.petals.topology.TopologyException;
import org.ow2.petals.topology.generated.Container;
import org.ow2.petals.topology.generated.Subdomain;
import org.ow2.petals.topology.generated.Topology;

public class StandaloneLauncher
extends AbstractLauncher {
    protected synchronized JMXClient getJMXClient() throws IOException, JAXBException, TopologyException, ConnectionErrorException, PetalsAdminDoesNotExistException, PetalsAdminServiceErrorException, ConfigurationException {
        if (this.jmxClient == null) {
            URL topologyURL = this.getClass().getResource("/topology.xml");
            if (topologyURL == null) {
                throw new IOException("Failed to reach the resource '/topology.xml'");
            }
            File topologyFile = null;
            try {
                topologyFile = new File(topologyURL.toURI().normalize());
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            Topology topology = TopologyBuilder.createTopology(topologyFile);
            Container localContainer = (Container)((Subdomain)topology.getDomain().getSubDomain().get(0)).getContainer().get(0);
            if (localContainer == null) {
                throw new ConfigurationException("Cannot retrieve the local container configuration");
            }
            this.jmxClient = new JMXClient(localContainer.getHost(), Integer.valueOf(localContainer.getJmxService().getRmiPort()), localContainer.getUser(), localContainer.getPassword());
        }
        return this.jmxClient;
    }

    protected String getDistributionName() {
        return "standalone";
    }
}

