/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher.tasks;

import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.api.server.PetalsServer;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.launcher.tasks.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointListTask
extends Task {
    protected PetalsServer petalsServer;

    public EndpointListTask(PetalsServer petalsServer) {
        this.petalsServer = petalsServer;
        this.setName("eplist");
        this.setShortcut("l");
        this.setDescription("Display the endpoint list");
    }

    @Override
    protected int doProcess(List<String> args) {
        try {
            List<ServiceEndpoint> list = this.petalsServer.getServiceEndpoints(true);
            System.out.println("Global Endpoints list");
            System.out.println("=====================");
            System.out.println();
            if (list != null && list.size() > 0) {
                int i = 1;
                for (ServiceEndpoint serviceEndpoint : list) {
                    System.out.println(" + Endpoint #" + i++);
                    System.out.println("  - Name       : " + serviceEndpoint.getEndpointName());
                    System.out.println("  - Service    : " + serviceEndpoint.getServiceName());
                    System.out.print("  - Interfaces : ");
                    if (serviceEndpoint.getInterfacesName() != null) {
                        for (int j = 0; j < serviceEndpoint.getInterfacesName().size(); ++j) {
                            QName itf = serviceEndpoint.getInterfacesName().get(j);
                            System.out.print(itf);
                            if (j >= serviceEndpoint.getInterfacesName().size()) continue;
                            System.out.print(", ");
                        }
                        System.out.println();
                    } else {
                        System.out.println("Undefined");
                    }
                    System.out.print("  - Location   : " + serviceEndpoint.getLocation().toString());
                    System.out.println();
                }
            } else {
                System.out.println("No endpoints");
            }
        }
        catch (PetalsException e) {
            e.printStackTrace(System.err);
        }
        return 1;
    }
}

