/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.api.server.PetalsServer;
import org.ow2.petals.kernel.api.server.PetalsStateListener;
import org.ow2.petals.launcher.util.Locker;

public class SystemExitHook
extends Thread {
    private static final long STOP_TIMEOUT = 15000L;
    private Locker locker;
    private PetalsStopThread petalsStopThread;

    public SystemExitHook(PetalsServer petalsServer, Locker locker, PetalsStateListener petalsListener) {
        this.petalsStopThread = new PetalsStopThread(petalsServer, petalsListener);
        this.locker = locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        try {
            System.out.println("PEtALS is stopping...");
            this.petalsStopThread.start();
            this.petalsStopThread.join(15000L);
            Date date = new Date(System.currentTimeMillis());
            if (this.petalsStopThread.run) {
                System.out.println("PEtALS container is not properly stopped - " + sdf.format(date));
            } else {
                System.out.println("PEtALS container is stopped - " + sdf.format(date));
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            Date date = new Date(System.currentTimeMillis());
            System.out.println("PEtALS container is not properly stopped - " + sdf.format(date) + ": " + e.getMessage());
        }
        finally {
            if (this.locker.isLocked()) {
                this.locker.unlock();
            }
        }
    }

    private class PetalsStopThread
    extends Thread {
        private PetalsServer petalsServer;
        private PetalsStateListener petalsListener;
        private volatile boolean run;

        public PetalsStopThread(PetalsServer petalsServer, PetalsStateListener petalsListener) {
            this.petalsServer = petalsServer;
            this.petalsListener = petalsListener;
        }

        public void run() {
            try {
                this.run = true;
                this.petalsServer.removePetalsStateListener(this.petalsListener);
                this.petalsServer.stop();
                this.run = false;
            }
            catch (PetalsException e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

