/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.commons.jbi.sugenerator.beans;

import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiNameFormatter;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class SuBeanForSa {
    protected String suName;
    protected String description;
    protected String zipArtifact;
    protected String componentName;

    public SuBeanForSa() {
    }

    public SuBeanForSa(SuBean suBean) {
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("MMMM d yyyy (H:m:s)");
        this.suName = JbiNameFormatter.removeNamespaceElements(suBean.getServiceName());
        if ("".equals(this.suName)) {
            SimpleDateFormat sdf2 = new SimpleDateFormat("dd_MM_yyyy__H_m_s_S");
            this.suName = "defaultSuName__" + sdf2.format(calendar.getTime());
        }
        this.componentName = suBean.getComponentName();
        this.zipArtifact = JbiNameFormatter.createSuName(suBean.getSuType(), suBean.getServiceName(), suBean.isConsume()) + ".zip";
        this.description = "Service Unit for " + this.componentName + ", generated on " + sdf.format(calendar.getTime());
    }

    public String getSuName() {
        return this.suName;
    }

    public void setSuName(String suName) {
        this.suName = suName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getZipArtifact() {
        return this.zipArtifact;
    }

    public void setZipArtifact(String zipArtifact) {
        this.zipArtifact = zipArtifact;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }
}

