/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.pubsub.service;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.pubsub.service.NotificationConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=NotificationConfiguration.class)})
public class FileNotificationConfigurationImpl
implements BindingController,
LifeCycleController,
NotificationConfiguration {
    public static final String FILE_CFG = "notification.cfg";
    public static final String TOPICS_NS_FILE = "kernel-topicns-rpupdate.xml";
    public static final String TOPICSSET_FILE = "kernel-topicset.xml";
    private static final String ENDPOINT_NAME = "endpoint";
    private static final String INTERFACE_NAME = "interface";
    private static final String SERVICE_NAME = "service";
    private static final String SUPPORTED_TOPICS = "supported-topics";
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    private Logger logger;
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    private List<String> supportedTopics;
    private QName serviceName;
    private QName interfaceName;
    private String endpointName;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.supportedTopics = new ArrayList<String>();
        this.loadConfig();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private void loadConfig() {
        File file = new File(this.configurationService.getContainerConfiguration().getRootDirectoryPath(), "conf");
        File file2 = new File(file, FILE_CFG);
        if (file2.exists() && file2.isFile()) {
            Properties properties = new Properties();
            try {
                String[] stringArray;
                properties.load(new FileInputStream(file2));
                this.endpointName = properties.getProperty(ENDPOINT_NAME);
                this.interfaceName = QName.valueOf(properties.getProperty(INTERFACE_NAME));
                this.serviceName = QName.valueOf(properties.getProperty(SERVICE_NAME));
                String string = properties.getProperty(SUPPORTED_TOPICS);
                if (string != null && (stringArray = (string = string.trim()).split(",")) != null) {
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = stringArray2[n2];
                        if (string2.trim().length() > 0) {
                            this.supportedTopics.add(string2.trim());
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public URL getTopicNamespaces() {
        File file = new File(this.configurationService.getContainerConfiguration().getRootDirectoryPath(), "conf");
        File file2 = new File(file, "topics");
        File file3 = new File(file2, TOPICS_NS_FILE);
        try {
            return file3.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    @Override
    public List<String> getSupportedTopics() {
        return this.supportedTopics;
    }

    @Override
    public QName getServiceName() {
        return this.serviceName;
    }

    @Override
    public QName getInterfaceName() {
        return this.interfaceName;
    }

    @Override
    public String getEndpointName() {
        return this.endpointName;
    }

    @Override
    public URL getTopicSet() {
        File file = new File(this.configurationService.getContainerConfiguration().getRootDirectoryPath(), "conf");
        File file2 = new File(file, "topics");
        File file3 = new File(file2, TOPICSSET_FILE);
        try {
            return file3.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

