/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.pubsub.service.internal;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.dsb.annotations.notification.Mode;
import org.petalslink.dsb.kernel.pubsub.service.internal.InternalNotificationConsumer;
import org.petalslink.dsb.kernel.pubsub.service.internal.NotificationTargetBean;
import org.w3c.dom.Element;

public class InternalNotificationConsumerWrapper
implements InternalNotificationConsumer {
    private static final Logger logger = Logger.getLogger(InternalNotificationConsumerWrapper.class.getName());
    private NotificationTargetBean bean;
    private QName topic;

    public InternalNotificationConsumerWrapper(NotificationTargetBean notificationTargetBean, QName qName) {
        this.bean = notificationTargetBean;
        this.topic = qName;
    }

    public NotificationTargetBean getTarget() {
        return this.bean;
    }

    public QName getTopic() {
        return this.topic;
    }

    public void notify(Notify notify) throws WsnbException {
        if (logger.isLoggable(Level.FINE)) {
            logger.info("Got a notify message...");
        }
        if (this.bean != null && this.bean.target != null && this.bean.m != null) {
            Class<?>[] classArray = this.bean.m.getParameterTypes();
            Object[] objectArray = new Object[1];
            if (classArray.length == 1) {
                if (this.bean.mode == Mode.WSN) {
                    objectArray[0] = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
                } else if (this.bean.mode == Mode.PAYLOAD) {
                    if (notify.getNotificationMessage() == null || notify.getNotificationMessage().size() > 1) {
                        throw new WsnbException("Bad number of notification messages!");
                    }
                    Element element = ((NotificationMessageHolderType)notify.getNotificationMessage().get(0)).getMessage().getAny();
                    if (element != null) {
                        objectArray[0] = element.getOwnerDocument();
                    }
                }
            } else {
                System.out.println("Multiple parameters are not supported!");
            }
            try {
                this.bean.m.invoke(this.bean.target, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

