/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.pubsub.service.internal;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.kernel.pubsub.service.NotificationCenter;
import org.petalslink.dsb.kernel.pubsub.service.internal.InternalNotificationConsumerWrapper;
import org.petalslink.dsb.kernel.pubsub.service.internal.NotificationConsumerRegistry;
import org.petalslink.dsb.kernel.pubsub.service.internal.NotificationConsumerScanner;
import org.petalslink.dsb.kernel.pubsub.service.internal.NotificationTargetBean;
import org.petalslink.dsb.notification.commons.NotificationHelper;
import org.petalslink.dsb.notification.commons.api.NotificationManager;
import org.w3c.dom.Node;

@FractalComponent
public class InternalNotificationManager
implements BindingController,
LifeCycleController {
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="scanner", signature=NotificationConsumerScanner.class)
    protected NotificationConsumerScanner scanner;
    @Requires(name="registry", signature=NotificationConsumerRegistry.class)
    protected NotificationConsumerRegistry registry;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycleListener(phase=Phase.START, priority=0)
    public void register() {
        NotificationProducerEngine notificationProducerEngine;
        NotificationManager notificationManager = NotificationCenter.get().getManager();
        if (notificationManager == null) {
            this.log.warning((Object)"Can not find the notification manager to register local subscribers!");
        }
        if ((notificationProducerEngine = notificationManager.getNotificationProducerEngine()) == null) {
            this.log.warning((Object)"Can not find the notification engine to register local subscribers!");
        }
        List<NotificationTargetBean> list = this.scanner.scan();
        for (NotificationTargetBean notificationTargetBean : list) {
            String[] stringArray;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Registering Java listener to the notification engine %s", notificationTargetBean.toString()));
            }
            if ((stringArray = notificationTargetBean.topic) == null) continue;
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                QName qName = QName.valueOf(string);
                String string2 = qName.getNamespaceURI();
                String string3 = null;
                String string4 = "";
                if (qName.getLocalPart().contains(":")) {
                    string3 = qName.getLocalPart().substring(qName.getLocalPart().indexOf(58) + 1);
                    string4 = qName.getLocalPart().substring(0, qName.getLocalPart().indexOf(58));
                } else {
                    string3 = qName.getLocalPart();
                }
                QName qName2 = new QName(string2, string3, string4);
                InternalNotificationConsumerWrapper internalNotificationConsumerWrapper = new InternalNotificationConsumerWrapper(notificationTargetBean, qName2);
                String string5 = "java://" + UUID.randomUUID();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Registering for topic '%s' with unique ID '%s'", qName2.toString(), string5));
                }
                try {
                    this.registry.add(string5, internalNotificationConsumerWrapper);
                    SubscribeResponse subscribeResponse = notificationProducerEngine.subscribe(NotificationHelper.createSubscribe((String)string5, (QName)qName2));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)String.format("Got response : %s", XMLHelper.createStringFromDOMDocument((Node)Wsnb4ServUtils.getWsnbWriter().writeSubscribeResponseAsDOM(subscribeResponse))));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.registry.remove(string5);
                }
                ++n2;
            }
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("scanner")) {
            if (!NotificationConsumerScanner.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + NotificationConsumerScanner.class.getName());
            }
            this.scanner = (NotificationConsumerScanner)object;
            return;
        }
        if (string.equals("registry")) {
            if (!NotificationConsumerRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + NotificationConsumerRegistry.class.getName());
            }
            this.registry = (NotificationConsumerRegistry)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("scanner");
        arrayList.add("registry");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("scanner")) {
            return this.scanner;
        }
        if (string.equals("registry")) {
            return this.registry;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("scanner")) {
            this.scanner = null;
            return;
        }
        if (string.equals("registry")) {
            this.registry = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

