/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.pubsub.service.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.notification.Notify;
import org.petalslink.dsb.fractal.utils.FractalHelper;
import org.petalslink.dsb.kernel.pubsub.service.internal.NotificationConsumerScanner;
import org.petalslink.dsb.kernel.pubsub.service.internal.NotificationTargetBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=NotificationConsumerScanner.class)})
public class NotificationConsumerScannerImpl
implements BindingController,
LifeCycleController,
NotificationConsumerScanner {
    private Logger logger;
    private LoggingUtil log;
    private Component component;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    @Override
    public List<NotificationTargetBean> scan() {
        List list;
        System.out.println("Scanning...");
        ArrayList<NotificationTargetBean> arrayList = new ArrayList<NotificationTargetBean>();
        Component component = FractalHelper.getRootComponent((Component)this.component);
        if (component != null && (list = FractalHelper.getAllComponentsWithMethodAnnotation((ContentController)FractalHelper.getContentController((Component)component), Notify.class)) != null) {
            for (Component component2 : list) {
                String string = FractalHelper.getName((Component)component2);
                Object object = FractalHelper.getContent((Component)component2);
                if (object == null) continue;
                Method[] methodArray = object.getClass().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.isAnnotationPresent(Notify.class)) {
                        this.log.debug((Object)String.format("Found notify annotation on method %s for component %s", method.getName(), string));
                        Notify notify = method.getAnnotation(Notify.class);
                        NotificationTargetBean notificationTargetBean = new NotificationTargetBean();
                        notificationTargetBean.m = method;
                        notificationTargetBean.target = object;
                        notificationTargetBean.topic = notify.topics();
                        notificationTargetBean.mode = notify.mode();
                        notificationTargetBean.id = string;
                        arrayList.add(notificationTargetBean);
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

