/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.gms;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.petalslink.gms.GMSClient;
import org.petalslink.gms.GMSException;
import org.petalslink.gms.GMSMessage;
import org.petalslink.gms.GMSMessageService;
import org.petalslink.gms.GMSService;
import org.petalslink.gms.Peer;

public class GMSMessageServiceImpl
implements GMSMessageService {
    private static final Logger LOG = Logger.getLogger(GMSMessageServiceImpl.class.getCanonicalName());
    private GMSService gmsService;

    public GMSMessageServiceImpl(GMSService gmsService) {
        this.gmsService = gmsService;
    }

    public void send(GMSMessage message, Peer to) throws GMSException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending message");
        }
        GMSClient client = this.gmsService.getClientFactory().getClient(to);
        client.send(message);
    }

    public void receive(GMSMessage message) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Receiving message");
        }
        this.gmsService.onMessage(message);
    }
}

