/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.gms;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.petalslink.gms.GMSClientFactory;
import org.petalslink.gms.GMSListener;
import org.petalslink.gms.GMSListenerManager;
import org.petalslink.gms.GMSListenerManagerImpl;
import org.petalslink.gms.GMSMessage;
import org.petalslink.gms.GMSMessageService;
import org.petalslink.gms.GMSMessageServiceImpl;
import org.petalslink.gms.GMSServer;
import org.petalslink.gms.GMSService;
import org.petalslink.gms.Gossiper;
import org.petalslink.gms.PeerManager;

public class GMSServiceImpl
implements GMSService {
    private static final Logger LOG = Logger.getLogger(GMSServiceImpl.class.getName());
    private Gossiper gossiper;
    private GMSMessageService gmsMessageService;
    private PeerManager peerManager;
    private GMSListenerManager listenerManager = new GMSListenerManagerImpl();
    private GMSClientFactory clientFactory;
    private GMSServer server;

    public GMSServiceImpl() {
        this.gmsMessageService = new GMSMessageServiceImpl(this);
        this.gossiper = new Gossiper(this);
        this.getListenerManager().register(this.gossiper);
    }

    public void start() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting the GMS Service");
        }
        if (this.server != null) {
            this.server.startServer();
        }
        if (this.gossiper != null) {
            this.gossiper.start();
        }
    }

    public void stop() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Stopping the service");
        }
        if (this.gossiper != null) {
            this.gossiper.stop();
        }
        if (this.server != null) {
            this.server.stopServer();
        }
    }

    public void onMessage(GMSMessage message) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Got a message, will dispatch if listeners are present");
        }
        Set<GMSListener> listeners = this.listenerManager.getListeners();
        for (GMSListener listener : listeners) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Got a message type " + (Object)((Object)message.type) + " from " + message.source.getName());
            }
            listener.onMessage(message);
        }
    }

    public PeerManager getPeerManager() {
        return this.peerManager;
    }

    public GMSMessageService getGMSMessageService() {
        return this.gmsMessageService;
    }

    public GMSListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public GMSClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public GMSListenerManager getGmsManager() {
        return this.listenerManager;
    }

    public GMSMessageService getGmsMessageService() {
        return this.gmsMessageService;
    }

    public GMSServer getServer() {
        return this.server;
    }

    public void setServer(GMSServer server) {
        this.server = server;
    }

    public void setPeerManager(PeerManager peerManager) {
        this.peerManager = peerManager;
    }

    public void setClientFactory(GMSClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }
}

