/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.gms;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.petalslink.gms.GMSException;
import org.petalslink.gms.GMSListener;
import org.petalslink.gms.GMSMessage;
import org.petalslink.gms.GMSService;
import org.petalslink.gms.Peer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gossiper
implements GMSListener {
    private static final Logger LOG = Logger.getLogger(Gossiper.class.getName());
    private Comparator<Peer> peerComparator = new Comparator<Peer>(){

        @Override
        public int compare(Peer peer1, Peer peer2) {
            return peer1.getName().compareTo(peer2.getName());
        }
    };
    private Set<Peer> livePeers = new ConcurrentSkipListSet<Peer>(this.peerComparator);
    private Set<Peer> unreachablePeers = new ConcurrentSkipListSet<Peer>(this.peerComparator);
    private ScheduledExecutorService executorService;
    ScheduledFuture<?> scheduledGossipTask;
    private Peer me;
    private GMSService gmsService;

    public Gossiper(GMSService gmsService) {
        this.gmsService = gmsService;
    }

    public void sendToUnreachableMember(GMSMessage message) {
        block4: {
            if (this.unreachablePeers.size() > 0) {
                Random random = new Random();
                int size = this.unreachablePeers.size();
                ArrayList<Peer> lpeers = new ArrayList<Peer>(this.unreachablePeers);
                int index = size == 1 ? 0 : random.nextInt(size);
                Peer to = (Peer)lpeers.get(index);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(this.me.getName() + " Sending to " + to.getName());
                }
                try {
                    this.gmsService.getGMSMessageService().send(message, to);
                    this.isActive(to, true);
                }
                catch (GMSException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine(e.getMessage());
                }
            }
        }
    }

    public void sendToLiveMember(GMSMessage message) {
        if (this.livePeers.size() == 0) {
            return;
        }
        Random random = new Random();
        int size = this.livePeers.size();
        ArrayList<Peer> lpeers = new ArrayList<Peer>(this.livePeers);
        int index = size == 1 ? 0 : random.nextInt(size);
        Peer to = (Peer)lpeers.get(index);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.me.getName() + " Sending to " + to.getName());
        }
        try {
            this.gmsService.getGMSMessageService().send(message, to);
        }
        catch (GMSException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(e.getMessage());
            }
            this.isActive(to, false);
        }
    }

    public void start() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting...");
        }
        this.me = this.gmsService.getPeerManager().getMe();
        Set<Peer> peers = this.gmsService.getPeerManager().getPeers();
        for (Peer peer : peers) {
            if (peer.getName().equals(this.me.getName())) continue;
            this.unreachablePeers.add(peer);
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledGossipTask = this.executorService.scheduleAtFixedRate(new GossipTask(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Stopping...");
        }
        this.scheduledGossipTask.cancel(false);
    }

    void sendMessageToRandom(GMSMessage message, Set<Peer> peers) throws GMSException {
        Random random = new Random();
        int size = peers.size();
        ArrayList<Peer> lpeers = new ArrayList<Peer>(peers);
        int index = size == 1 ? 0 : random.nextInt(size);
        Peer to = (Peer)lpeers.get(index);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.me.getName() + " Sending to " + to.getName());
        }
        this.gmsService.getGMSMessageService().send(message, to);
    }

    Set<Peer> getLivePeers() {
        return new HashSet<Peer>(this.livePeers);
    }

    GMSMessage createPingMessage() {
        GMSMessage message = new GMSMessage();
        message.source = this.me;
        message.type = GMSMessage.Type.PING;
        return message;
    }

    @Override
    public void onMessage(GMSMessage message) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Gossiper @ " + this.me.getName() + " got a message from " + message.source.getName());
        }
        if (message != null && message.getSource() != this.me) {
            this.isActive(message.getSource(), true);
        }
    }

    void isActive(Peer peer, boolean active) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Peer " + peer.getName() + " is alive : " + active);
        }
        if (active) {
            this.livePeers.add(peer);
            this.unreachablePeers.remove(peer);
        } else {
            this.livePeers.remove(peer);
            this.unreachablePeers.add(peer);
        }
    }

    private class GossipTask
    implements Runnable {
        private GossipTask() {
        }

        public void run() {
            GMSMessage message = Gossiper.this.createPingMessage();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sending to live members...");
            }
            Gossiper.this.sendToLiveMember(message);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sending to unreachable member...");
            }
            Gossiper.this.sendToUnreachableMember(message);
        }
    }
}

