/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.jmx;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServer;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.fractal.jmx.agent.AdminAttributes;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.jmx.JMXService;
import org.ow2.petals.communication.jmx.RemoteJMXServer;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jmx.JMXConnection;
import org.ow2.petals.jmx.exception.ConnectionErrorException;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=JMXService.class)})
public class PlatformJMXServiceImpl
implements BindingController,
LifeCycleController,
JMXService {
    private LoggerFactory loggerFactory;
    protected LoggingUtil log;
    private Logger logger;
    @Requires(name="adminAtt", signature=AdminAttributes.class)
    protected AdminAttributes adminAttributes;
    @Requires(name="topology", signature=TopologyService.class)
    protected TopologyService topologyService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    private Map<String, JMXConnection> petalsJMXConnections;
    private String containerName;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public RemoteJMXServer getRemoteJMXServer(String string) throws PetalsException {
        this.log.start("Container Name : " + string);
        RemoteJMXServer remoteJMXServer = null;
        if (this.containerName.equals(string)) {
            remoteJMXServer = new RemoteJMXServer(this.getLocalJMXServer());
        } else {
            ContainerConfiguration containerConfiguration = this.topologyService.getContainerConfiguration(string);
            try {
                JMXConnection jMXConnection;
                if (this.petalsJMXConnections.containsKey(string)) {
                    jMXConnection = this.petalsJMXConnections.get(string);
                } else {
                    jMXConnection = new JMXConnection(containerConfiguration.getHost(), containerConfiguration.getJmxRMIConnectorPort(), containerConfiguration.getUser(), containerConfiguration.getPassword());
                    this.petalsJMXConnections.put(containerConfiguration.getName(), jMXConnection);
                }
                remoteJMXServer = new RemoteJMXServer(jMXConnection.getMBeanServerConnection());
            }
            catch (ConnectionErrorException connectionErrorException) {
                this.petalsJMXConnections.remove(containerConfiguration.getName());
                throw new PetalsException("Failed to connect the the remote JMX service of the container '" + string + "'");
            }
        }
        this.log.end();
        return remoteJMXServer;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public MBeanServer getLocalJMXServer() {
        return this.adminAttributes.getRawMBeanServer();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IllegalLifeCycleException {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
        this.petalsJMXConnections = new Hashtable<String, JMXConnection>();
        this.containerName = this.configurationService.getContainerConfiguration().getName();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws IllegalLifeCycleException {
        this.log.call();
        for (String string : this.petalsJMXConnections.keySet()) {
            try {
                this.log.debug("Try to disconnect JMX connection to container : " + string);
                this.petalsJMXConnections.get(string).disconnect();
            }
            catch (ConnectionErrorException connectionErrorException) {
                this.log.debug((Object)connectionErrorException);
            }
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("adminAtt")) {
            if (!AdminAttributes.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminAttributes.class.getName());
            }
            this.adminAttributes = (AdminAttributes)object;
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("adminAtt");
        arrayList.add("topology");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("adminAtt")) {
            return this.adminAttributes;
        }
        if (string.equals("topology")) {
            return this.topologyService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("adminAtt")) {
            this.adminAttributes = null;
            return;
        }
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

