/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.jndi.client.naming;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.ow2.petals.communication.jndi.agent.JNDIAgentService;
import org.ow2.petals.communication.jndi.client.naming.JNDIConnection;
import org.ow2.petals.communication.jndi.client.naming.JNDILocalConnection;
import org.ow2.petals.communication.jndi.client.naming.NamingContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingContextFactory
implements InitialContextFactory {
    @Override
    public Context getInitialContext(Hashtable<?, ?> hashtable) throws NamingException {
        if (hashtable.containsKey("org.ow2.petals.communication.jndi.agent.local")) {
            return null;
        }
        String string = (String)hashtable.get("java.naming.provider.url");
        URI uRI = null;
        if (string != null) {
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new NamingException("You must specify a proper URI in the property java.naming.provider.url");
            }
        } else {
            throw new NamingException("You must specify the property java.naming.provider.url");
        }
        JNDIConnection jNDIConnection = null;
        jNDIConnection = new JNDIConnection(uRI);
        NamingContextImpl namingContextImpl = new NamingContextImpl(hashtable, jNDIConnection, "/", false);
        return namingContextImpl;
    }

    public Context getInitialContext(Hashtable<?, ?> hashtable, JNDIAgentService jNDIAgentService) throws NamingException {
        JNDILocalConnection jNDILocalConnection = new JNDILocalConnection(jNDIAgentService);
        NamingContextImpl namingContextImpl = new NamingContextImpl(hashtable, jNDILocalConnection, "/", true);
        return namingContextImpl;
    }
}

