/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.lifecycle;

import javax.jbi.JBIException;
import javax.jbi.management.LifeCycleMBean;
import org.ow2.petals.container.lifecycle.ForbiddenActionJBIException;
import org.ow2.petals.util.LoggingUtil;

public abstract class LifeCycleAbstract
implements LifeCycleMBean {
    protected Object activitySynchronizer = new Byte[0];
    protected boolean initialized;
    protected LoggingUtil log;
    protected String name;
    protected boolean forcedState = false;
    private String state = "Unknown";
    private final Object stateLock = new Object();

    public abstract void doInit() throws JBIException;

    public abstract void doShutdown() throws JBIException;

    public abstract void doStart() throws JBIException;

    public abstract void doStop() throws JBIException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentState() {
        Object object = this.stateLock;
        synchronized (object) {
            block4: {
                if ("Shutdown".equals(this.state) || "Started".equals(this.state) || "Stopped".equals(this.state) || "Unknown".equals(this.state)) break block4;
                return "Unknown";
            }
            return this.state;
        }
    }

    public boolean isShutdownState() {
        return "Shutdown".equals(this.getCurrentState());
    }

    public boolean isStartedState() {
        return "Started".equals(this.getCurrentState());
    }

    public boolean isStoppedState() {
        return "Stopped".equals(this.getCurrentState());
    }

    public boolean isUnknownState() {
        return "Unknown".equals(this.getCurrentState());
    }

    public void setForcedState(boolean bl) {
        this.forcedState = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws JBIException {
        this.log.start();
        if ("Shutdown".equals(this.state)) {
            this.log.warning("The component '" + this.name + "' is already shut down");
        } else {
            if (this.forcedState || "Stopped".equals(this.state)) {
                Object object = this.activitySynchronizer;
                synchronized (object) {
                    try {
                        this.doShutdown();
                        this.setState("Shutdown");
                        this.initialized = false;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ForbiddenActionJBIException) {
                            this.log.warning(throwable.getMessage());
                        }
                        this.log.error(throwable.getMessage(), throwable);
                        this.setState("Unknown");
                        JBIException jBIException = new JBIException("An exception occured while shutting down the " + this.getJBIArtifactType() + " '" + this.name + "' : " + throwable.getMessage());
                        throw jBIException;
                    }
                }
            }
            JBIException jBIException = new JBIException("The " + this.getJBIArtifactType() + " '" + this.name + "' cannot be shut down in this state: " + this.state);
            throw jBIException;
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JBIException {
        this.log.start();
        if ("Started".equals(this.state)) {
            this.log.warning("The component '" + this.name + "' is already started");
        } else {
            if (this.forcedState || "Shutdown".equals(this.state) || "Stopped".equals(this.state)) {
                Object object = this.activitySynchronizer;
                synchronized (object) {
                    try {
                        if (!this.initialized) {
                            this.doInit();
                            this.initialized = true;
                        }
                        this.doStart();
                        this.setState("Started");
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ForbiddenActionJBIException) {
                            this.log.warning(throwable.getMessage());
                        }
                        this.log.error(throwable.getMessage(), throwable);
                        this.setState("Unknown");
                        JBIException jBIException = new JBIException("An exception occured while starting the " + this.getJBIArtifactType() + " '" + this.name + "' : " + throwable.getMessage());
                        throw jBIException;
                    }
                }
            }
            JBIException jBIException = new JBIException("The " + this.getJBIArtifactType() + " '" + this.name + "' cannot be started in this state: " + this.state);
            throw jBIException;
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JBIException {
        this.log.start();
        if ("Stopped".equals(this.state)) {
            this.log.warning("The component '" + this.name + "' is already stopped");
        } else if (this.forcedState || "Started".equals(this.state)) {
            Object object = this.activitySynchronizer;
            synchronized (object) {
                try {
                    this.doStop();
                    this.setState("Stopped");
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ForbiddenActionJBIException) {
                        this.log.warning(throwable.getMessage());
                    }
                    this.log.error(throwable.getMessage(), throwable);
                    this.setState("Unknown");
                    JBIException jBIException = new JBIException("An exception occured while stopping the " + this.getJBIArtifactType() + " '" + this.name + "' : " + throwable.getMessage());
                    throw jBIException;
                }
            }
        }
        this.log.end();
    }

    protected abstract String getJBIArtifactType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(String string) throws JBIException {
        if (!("Shutdown".equals(string) || "Started".equals(string) || "Stopped".equals(string) || "Unknown".equals(string))) {
            throw new JBIException("State '" + string + "' isn't defined by the JBI specification. No state changement done.");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.state = string;
        }
    }
}

