/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.SharedLibraryLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.system.classloader.ClassLoaderService;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SharedLibraryLifeCycle.class)})
public class SharedLibraryLifeCycleImpl
implements BindingController,
LifeCycleController,
SharedLibraryLifeCycle {
    public static final String INSTALLED = "Installed";
    private LoggerFactory loggerFactory;
    public static final String UNINSTALLED = "Uninstalled";
    private String state = "Uninstalled";
    private LoggingUtil log;
    private Logger logger;
    private Jbi.SharedLibrary sharedLibrary;
    private final List<String> componentNames = new ArrayList<String>();
    private URL[] baseUrls;
    private boolean useParentFirst;
    @Requires(name="classloader", signature=ClassLoaderService.class)
    private ClassLoaderService loaderService;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void init(Jbi.SharedLibrary sharedLibrary, URL[] uRLArray, boolean bl) {
        this.sharedLibrary = sharedLibrary;
        this.baseUrls = uRLArray;
        this.useParentFirst = bl;
        this.state = UNINSTALLED;
    }

    @Override
    public boolean isLoaded() {
        return INSTALLED.equals(this.state);
    }

    @Override
    public void loadSharedLibrary() throws PetalsException {
        this.log.start();
        String string = String.valueOf(this.sharedLibrary.getIdentification().getName()) + "-" + this.sharedLibrary.getVersion();
        List list = this.sharedLibrary.getSharedLibraryClassPath().getPathElement();
        this.loaderService.createSharedLibraryClassLoader(string, this.baseUrls, list, this.useParentFirst);
        this.state = INSTALLED;
        this.log.end();
    }

    @Override
    public void unLoadSharedLibrary() {
        this.log.start();
        String string = String.valueOf(this.sharedLibrary.getIdentification().getName()) + "-" + this.sharedLibrary.getVersion();
        this.loaderService.deleteClassLoader(string);
        this.state = UNINSTALLED;
        this.log.end();
    }

    @Override
    public void registerComponent(String string) {
        this.componentNames.add(string);
    }

    @Override
    public void unregisterComponent(String string) {
        this.componentNames.remove(string);
    }

    @Override
    public List<String> getRegisteredComponents() {
        return this.componentNames;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
    }

    @Override
    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
        this.log.call();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("classloader")) {
            if (!ClassLoaderService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ClassLoaderService.class.getName());
            }
            this.loaderService = (ClassLoaderService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("classloader");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("classloader")) {
            return this.loaderService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("classloader")) {
            this.loaderService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

