/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jbi.JBIException;
import org.ow2.petals.util.LoggingUtil;

public abstract class AbstractThread
extends Thread {
    protected JBIException jbiException;
    protected BlockingQueue<String> requestQueue;
    protected BlockingQueue<String> responseQueue;
    public static final String SHUTDOWNTHREAD = "SHUTDOWNTHREAD";
    protected final LoggingUtil logger;
    protected long timeout = 0L;

    public AbstractThread(long l, LoggingUtil loggingUtil) {
        this.logger = loggingUtil;
        this.requestQueue = new ArrayBlockingQueue<String>(1);
        this.responseQueue = new ArrayBlockingQueue<String>(1);
        this.timeout = l;
    }

    public void run() {
        boolean bl = true;
        while (bl) {
            try {
                String string = this.requestQueue.take();
                bl = this.doTask(string);
                this.responseQueue.put(string);
            }
            catch (InterruptedException interruptedException) {
                this.logger.error("The life-cycle thread '" + this.getName() + "' has been interrupted, probably due to a reached timeout");
            }
            catch (Throwable throwable) {
                this.logger.error(throwable);
            }
        }
    }

    protected abstract boolean doTask(String var1);

    protected void execute(String string) throws JBIException {
        if (!this.isAlive()) {
            throw new JBIException("The thread '" + this.getName() + "' is dead");
        }
        try {
            this.requestQueue.put(string);
            String string2 = null;
            string2 = this.timeout > 0L ? this.responseQueue.poll(this.timeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            if (string2 == null) {
                this.interrupt();
                throw new JBIException("Timeout exceeded when executing " + string + " management task. Assuming the task is blocked.");
            }
            if (this.jbiException != null) {
                JBIException jBIException = this.jbiException;
                this.jbiException = null;
                throw jBIException;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new JBIException("Interrupted exception during " + string + " task execution.", (Throwable)interruptedException);
        }
    }

    public void shutdownThread() throws JBIException {
        this.execute(SHUTDOWNTHREAD);
    }
}

