/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.thread;

import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;
import javax.management.ObjectName;
import org.ow2.petals.container.thread.AbstractThread;
import org.ow2.petals.util.LoggingUtil;

public class BootstrapThread
extends AbstractThread
implements Bootstrap {
    private ObjectName objectName;
    private Bootstrap jbiBootStrap;
    private InstallationContext installContext;
    public static final String INSTALL = "INSTALL";
    public static final String UNINSTALL = "UNINSTALL";
    public static final String INIT = "INIT";
    public static final String CLEANUP = "CLEANUP";
    public static final String EXTMBEAN = "EXTMBEAN";

    public BootstrapThread(String string, Bootstrap bootstrap, long l, LoggingUtil loggingUtil) {
        super(l, loggingUtil);
        this.jbiBootStrap = bootstrap;
        this.setName(String.valueOf(string) + " - Bootstrap Thread");
    }

    protected boolean doTask(String string) {
        boolean bl = true;
        try {
            if (CLEANUP.equals(string)) {
                this.jbiBootStrap.cleanUp();
            } else if (INSTALL.equals(string)) {
                this.jbiBootStrap.onInstall();
            } else if (UNINSTALL.equals(string)) {
                this.jbiBootStrap.onUninstall();
            } else if (INIT.equals(string)) {
                this.jbiBootStrap.init(this.installContext);
            } else if (EXTMBEAN.equals(string)) {
                this.objectName = this.jbiBootStrap.getExtensionMBeanName();
            } else if ("SHUTDOWNTHREAD".equals(string)) {
                bl = false;
            } else {
                this.jbiException = new JBIException("Unknown action : " + string);
            }
        }
        catch (Throwable throwable) {
            this.jbiException = new JBIException("Bootstrap failure on " + string, throwable);
        }
        return bl;
    }

    public void cleanUp() throws JBIException {
        this.execute(CLEANUP);
    }

    public ObjectName getExtensionMBeanName() {
        try {
            this.execute(EXTMBEAN);
        }
        catch (JBIException jBIException) {
            jBIException.printStackTrace();
        }
        ObjectName objectName = this.objectName;
        this.objectName = null;
        return objectName;
    }

    public void init(InstallationContext installationContext) throws JBIException {
        this.installContext = installationContext;
        this.execute(INIT);
    }

    public void onInstall() throws JBIException {
        this.execute(INSTALL);
    }

    public void onUninstall() throws JBIException {
        this.execute(UNINSTALL);
    }
}

