/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.component.context;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.management.MBeanNames;
import javax.jbi.messaging.MessagingException;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.api.TopicalLogger;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.container.lifecycle.ComponentContextCommunication;
import org.ow2.petals.container.lifecycle.Installer;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.LinkType;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.DeliveryChannel;
import org.ow2.petals.jbi.messaging.exchange.DeliveryChannelImpl;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.jbi.security.SecurityContext;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.ParameterCheckHelper;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContextImpl
implements ComponentContext {
    protected WSDL4ComplexWsdlReader wsdlReader;
    protected DeliveryChannel deliveryChannel;
    protected Set<javax.jbi.servicedesc.ServiceEndpoint> externalEndpoints;
    protected Set<javax.jbi.servicedesc.ServiceEndpoint> internalEndpoints;
    protected Component jbiComponent;
    private MonologFactory loggerFactory;
    protected final ComponentContextCommunication componentContextCommunication;
    protected LoggingUtil logger;
    private final Map<String, String> componentLoggerRBNames;
    private SecurityContext securityContext;

    public ComponentContextImpl(ComponentContextCommunication componentContextCommunication) {
        this.componentContextCommunication = componentContextCommunication;
        Logger logger = this.getLogger();
        this.logger = new LoggingUtil(logger);
        this.componentLoggerRBNames = new HashMap<String, String>();
        this.internalEndpoints = new HashSet<javax.jbi.servicedesc.ServiceEndpoint>();
        this.externalEndpoints = new HashSet<javax.jbi.servicedesc.ServiceEndpoint>();
        try {
            this.wsdlReader = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader();
        }
        catch (WSDL4ComplexWsdlException wSDL4ComplexWsdlException) {
            this.logger.warning("Can not initialize WSDL Reader : " + wSDL4ComplexWsdlException.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.jbi.servicedesc.ServiceEndpoint activateEndpoint(QName qName, String string) throws JBIException {
        ServiceEndpoint serviceEndpoint;
        Object object;
        this.logger.start();
        ParameterCheckHelper.isNullParameter(qName, "serviceName");
        ParameterCheckHelper.isNullParameter(qName, "endpointName");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        final QName qName2 = qName;
        final String string2 = string;
        Document document = this.getComponent().getServiceDescription(new javax.jbi.servicedesc.ServiceEndpoint(){

            public QName getServiceName() {
                return qName2;
            }

            public QName[] getInterfaces() {
                return null;
            }

            public String getEndpointName() {
                return string2;
            }

            public DocumentFragment getAsReference(QName qName) {
                return null;
            }
        });
        ArrayList<Object> arrayList = new ArrayList<Object>(0);
        if (document != null) {
            arrayList.addAll(this.getInterfacesFromComponentDescription(document, qName, string));
        } else {
            object = new QName(qName.getNamespaceURI(), "UNRESOLVED_INTERFACE" + qName.getLocalPart());
            this.logger.warning("No interface has been found in the component service description, set default to " + object);
            arrayList.add(object);
        }
        object = this.getProperties(qName, string);
        try {
            this.logger.debug("Activating the newly created endpoint in the registry");
            serviceEndpoint = this.componentContextCommunication.getEndpointRegistry().activateEndpoint(qName, string, arrayList.toArray(new QName[arrayList.size()]), document, this.componentContextCommunication.getAddress(), (Map<String, String>)object);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var10_12 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.internalEndpoints.add(serviceEndpoint);
        }
        this.logger.end();
        return serviceEndpoint;
    }

    protected Map<String, String> getProperties(QName qName, String string) {
        Map<Object, Object> map = null;
        if (this.componentContextCommunication.getEndpointPropertiesService() != null) {
            map = this.componentContextCommunication.getEndpointPropertiesService().getProperties(string, qName);
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deactivateEndpoint(javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint) throws JBIException {
        this.logger.start();
        ParameterCheckHelper.isNullParameter(serviceEndpoint, "endpoint");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.componentContextCommunication.getEndpointRegistry().deactivateEndpoint(serviceEndpoint.getEndpointName(), serviceEndpoint.getServiceName());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var3_5 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.internalEndpoints.remove(serviceEndpoint);
        }
        this.logger.end();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deregisterAllEndpoints() throws JBIException {
        this.logger.start();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint;
            Iterator<javax.jbi.servicedesc.ServiceEndpoint> iterator = this.internalEndpoints.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    iterator = this.externalEndpoints.iterator();
                    break;
                }
                serviceEndpoint = iterator.next();
                this.componentContextCommunication.getEndpointRegistry().deactivateEndpoint(serviceEndpoint.getEndpointName(), serviceEndpoint.getServiceName());
            }
            while (iterator.hasNext()) {
                serviceEndpoint = iterator.next();
                this.componentContextCommunication.getEndpointRegistry().deregisterExternalEndpoint(serviceEndpoint.getEndpointName(), serviceEndpoint.getServiceName());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.internalEndpoints.clear();
            this.externalEndpoints.clear();
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.internalEndpoints.clear();
            this.externalEndpoints.clear();
            Thread.currentThread().setContextClassLoader(classLoader);
            this.logger.end();
            return;
        }
    }

    public void deregisterExternalEndpoint(javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint) throws JBIException {
        this.logger.start();
        ParameterCheckHelper.isNullParameter(serviceEndpoint, "externalEndpoint");
        this.componentContextCommunication.getEndpointRegistry().deregisterExternalEndpoint(serviceEndpoint.getEndpointName(), serviceEndpoint.getServiceName());
        this.externalEndpoints.remove(serviceEndpoint);
        this.logger.end();
    }

    @Override
    public ServiceEndpoint getAddress() {
        return this.componentContextCommunication.getAddress();
    }

    @Override
    public Component getComponent() {
        return this.jbiComponent;
    }

    public String getComponentName() {
        return this.componentContextCommunication.getJBIDescriptor().getComponent().getIdentification().getName();
    }

    @Override
    public DeliveryChannel getDeliveryChannel() throws MessagingException {
        this.logger.start();
        if (this.deliveryChannel == null) {
            this.deliveryChannel = new DeliveryChannelImpl(this);
        } else if (!this.deliveryChannel.isOpened()) {
            this.deliveryChannel = new DeliveryChannelImpl(this);
        }
        this.logger.end();
        return this.deliveryChannel;
    }

    public DeliveryChannel getDeliveryChannelImpl() {
        return this.deliveryChannel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.jbi.servicedesc.ServiceEndpoint getEndpoint(QName qName, String string) {
        this.logger.start();
        ParameterCheckHelper.isNullParameter(qName, "service");
        ParameterCheckHelper.isNullParameter(string, "name");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        ServiceEndpoint serviceEndpoint = null;
        try {
            try {
                serviceEndpoint = this.componentContextCommunication.getEndpointRegistry().getEndpoint(qName, string);
            }
            catch (Exception exception) {
                this.logger.warning(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var6_8 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.logger.end();
            return serviceEndpoint;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document getEndpointDescriptor(javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint) throws JBIException {
        Document document;
        block4: {
            block5: {
                this.logger.start();
                document = null;
                ParameterCheckHelper.isNullParameter(serviceEndpoint, "endpoint");
                if (!(serviceEndpoint instanceof ServiceEndpoint)) break block5;
                this.logger.debug("Just get the description from the service endpoint");
                if (this.getEndpoint(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName()) == null) break block4;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                try {
                    document = ((ServiceEndpoint)serviceEndpoint).getDescription();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    Thread.currentThread().setContextClassLoader(classLoader);
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    Thread.currentThread().setContextClassLoader(classLoader);
                    if (document == null) {
                        this.logger.debug("Can not find the service description in the service endpoint");
                    }
                    break block4;
                }
            }
            this.logger.debug("the Endpoint type must be " + ServiceEndpoint.class.getName());
        }
        this.logger.end();
        return document;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.jbi.servicedesc.ServiceEndpoint[] getEndpoints(QName qName) {
        this.logger.start();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        javax.jbi.servicedesc.ServiceEndpoint[] serviceEndpointArray = null;
        try {
            try {
                serviceEndpointArray = this.componentContextCommunication.getEndpointRegistry().getInternalEndpointsForInterface(qName, LinkType.STANDARD);
            }
            catch (Exception exception) {
                this.logger.warning(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var5_7 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.logger.end();
            return serviceEndpointArray;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.jbi.servicedesc.ServiceEndpoint[] getEndpointsForService(QName qName) {
        this.logger.start();
        ParameterCheckHelper.isNullParameter(qName, "serviceName");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        javax.jbi.servicedesc.ServiceEndpoint[] serviceEndpointArray = null;
        try {
            try {
                serviceEndpointArray = this.componentContextCommunication.getEndpointRegistry().getInternalEndpointsForService(qName, LinkType.STANDARD);
            }
            catch (RegistryException registryException) {
                this.logger.warning(registryException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var5_7 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.logger.end();
            return serviceEndpointArray;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.jbi.servicedesc.ServiceEndpoint[] getExternalEndpoints(QName qName) {
        this.logger.start();
        ParameterCheckHelper.isNullParameter(qName, "interfaceName");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        javax.jbi.servicedesc.ServiceEndpoint[] serviceEndpointArray = null;
        try {
            try {
                serviceEndpointArray = this.componentContextCommunication.getEndpointRegistry().getExternalEndpointsForInterface(qName);
            }
            catch (RegistryException registryException) {
                this.logger.warning(registryException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var5_7 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.logger.end();
            return serviceEndpointArray;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.jbi.servicedesc.ServiceEndpoint[] getExternalEndpointsForService(QName qName) {
        this.logger.start();
        ParameterCheckHelper.isNullParameter(qName, "serviceName");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        javax.jbi.servicedesc.ServiceEndpoint[] serviceEndpointArray = null;
        try {
            try {
                serviceEndpointArray = this.componentContextCommunication.getEndpointRegistry().getExternalEndpointsForService(qName);
            }
            catch (RegistryException registryException) {
                this.logger.warning(registryException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var5_7 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.logger.end();
            return serviceEndpointArray;
        }
    }

    public String getInstallRoot() {
        this.logger.call();
        return this.componentContextCommunication.getInstallationRoot();
    }

    public java.util.logging.Logger getLogger(String string, String string2) throws MissingResourceException, JBIException {
        this.logger.start();
        String string3 = this.getComponentName();
        if (string == null) {
            throw new IllegalArgumentException("suffix must not be null");
        }
        if (string.length() > 0) {
            string3 = String.valueOf(string3) + "." + string;
        }
        java.util.logging.Logger logger = this.getComponentLogger(string3, string2);
        this.logger.end();
        return logger;
    }

    public MBeanNames getMBeanNames() {
        this.logger.call();
        return this.componentContextCommunication.getAdminService().getMBeanNames();
    }

    public MBeanServer getMBeanServer() {
        this.logger.call();
        return this.componentContextCommunication.getAdminService().getMBeanServer();
    }

    public InitialContext getNamingContext() {
        this.logger.call();
        return this.componentContextCommunication.getInitialContext();
    }

    public Object getTransactionManager() {
        this.logger.call();
        TransactionManager transactionManager = this.componentContextCommunication.getTransactionManagerService();
        return transactionManager;
    }

    public String getWorkspaceRoot() {
        this.logger.call();
        return this.componentContextCommunication.getWorkspaceRoot();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerExternalEndpoint(javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint) throws JBIException {
        this.logger.start();
        ParameterCheckHelper.isNullParameter(serviceEndpoint, "externalEndpoint");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.componentContextCommunication.getEndpointRegistry().registerExternalEndpoint(serviceEndpoint);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var3_5 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.externalEndpoints.add(serviceEndpoint);
        }
        this.logger.end();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.jbi.servicedesc.ServiceEndpoint resolveEndpointReference(DocumentFragment documentFragment) {
        this.logger.start();
        ParameterCheckHelper.isNullParameter(documentFragment, "epr");
        javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Installer installer;
            Installer[] installerArray = this.componentContextCommunication.getAdminService().getInstallers();
            int n = installerArray.length;
            int n2 = 0;
            while (n2 < n && (serviceEndpoint = (installer = installerArray[n2]).getComponent().resolveEndpointReference(documentFragment)) == null) {
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var8_10 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.logger.end();
            return serviceEndpoint;
        }
    }

    @Override
    public void setComponent(Component component) {
        this.jbiComponent = component;
    }

    public void setDeliveryChannel(DeliveryChannel deliveryChannel) {
        this.deliveryChannel = deliveryChannel;
    }

    public Jbi getJbi() {
        return this.componentContextCommunication.getJBIDescriptor();
    }

    @Override
    public RouterService getRouter() {
        return this.componentContextCommunication.getRouterService();
    }

    @Override
    public Logger getLogger() {
        return this.componentContextCommunication.getLogger();
    }

    @Override
    public void clear() {
        this.deliveryChannel = null;
        this.jbiComponent = null;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    private java.util.logging.Logger getComponentLogger(String string, String string2) throws JBIException {
        this.logger.start();
        String string3 = this.componentLoggerRBNames.get(string);
        if (string3 != null && !string3.equals(string2)) {
            throw new JBIException("Logger already exists for suffix " + string + " but with " + string3 + " as resource bundle instead of the expected " + string2);
        }
        java.util.logging.Logger logger = null;
        if (this.loggerFactory == null) {
            this.loggerFactory = Monolog.getMonologFactory();
        }
        TopicalLogger topicalLogger = (TopicalLogger)this.loggerFactory.getLogger("Petals.Container.Components." + string, string2);
        topicalLogger.setAdditivity(false);
        if (topicalLogger.getHandler().length == 0) {
            try {
                topicalLogger.addHandler(this.loggerFactory.getHandler("petalsConsole"));
                topicalLogger.addHandler(this.loggerFactory.getHandler("petalsFile"));
            }
            catch (Exception exception) {
                throw new JBIException((Throwable)exception);
            }
            this.componentLoggerRBNames.put(string, string2);
        }
        logger = (java.util.logging.Logger)((Object)topicalLogger);
        this.logger.end();
        return logger;
    }

    protected List<QName> getInterfacesFromComponentDescription(Document document, QName qName, String string) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        try {
            Description description = this.wsdlReader.read(document);
            if (description != null && description.getServices() != null) {
                Service service = (Service)description.getService(qName);
                if (service != null) {
                    if (service.getEndpoint(string) != null) {
                        if (service.getInterface() != null && ((InterfaceType)service.getInterface()).getQName() != null) {
                            arrayList.add(((InterfaceType)service.getInterface()).getQName());
                        } else {
                            this.logger.warning("No interface for endpoint in component description for service '" + service.getQName() + "'");
                        }
                    } else {
                        this.logger.warning("No endpoint in component description for service '" + qName + "'");
                    }
                } else {
                    this.logger.warning("No such service in component description '" + qName + "'");
                }
            }
        }
        catch (WSDL4ComplexWsdlException wSDL4ComplexWsdlException) {
            this.logger.warning(wSDL4ComplexWsdlException.getMessage());
        }
        catch (WSDLException wSDLException) {
            this.logger.warning(wSDLException.getMessage());
        }
        catch (URISyntaxException uRISyntaxException) {
            this.logger.warning(uRISyntaxException.getMessage());
        }
        return arrayList;
    }
}

